/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.integration;

import java.util.UUID;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeClearEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.types.InheritanceNode;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.LuckPermsHook;

public class LPEvents {
    private final DMentions plugin;
    private final LuckPermsHook luckPermsHook;

    public LPEvents(DMentions plugin, LuckPermsHook luckPermsHook) {
        this.plugin = plugin;
        this.luckPermsHook = luckPermsHook;
    }

    public void register() {
        EventBus eventBus = this.luckPermsHook.getAPI().getEventBus();
        eventBus.subscribe((Object)this.plugin, NodeAddEvent.class, this::onAdd);
        eventBus.subscribe((Object)this.plugin, NodeRemoveEvent.class, this::onRemove);
        eventBus.subscribe((Object)this.plugin, NodeClearEvent.class, this::onClear);
    }

    private void onAdd(NodeAddEvent event) {
        if (!event.isUser()) {
            return;
        }
        User user = (User)event.getTarget();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (event.getNode() instanceof InheritanceNode) {
                Player player = Bukkit.getPlayer((UUID)user.getUniqueId());
                if (player == null) {
                    return;
                }
                this.luckPermsHook.updatePlayerGroupCache(player);
            }
        });
    }

    private void onRemove(NodeRemoveEvent event) {
        if (!event.isUser()) {
            return;
        }
        User user = (User)event.getTarget();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (event.getNode() instanceof InheritanceNode) {
                Player player = Bukkit.getPlayer((UUID)user.getUniqueId());
                if (player == null) {
                    return;
                }
                this.luckPermsHook.updatePlayerGroupCache(player);
            }
        });
    }

    private void onClear(NodeClearEvent event) {
        if (!event.isUser()) {
            return;
        }
        User user = (User)event.getTarget();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Player player = Bukkit.getPlayer((UUID)user.getUniqueId());
            if (player == null) {
                return;
            }
            this.luckPermsHook.updatePlayerGroupCache(player);
        });
    }
}

