/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.integration;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import net.ess3.api.events.VanishStatusChangeEvent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.IHook;
import org.nandayo.dmentions.provider.VanishProvider;
import org.nandayo.dmentions.service.message.Message;

public class EssentialsHook
implements IHook,
VanishProvider {
    @NotNull
    private final DMentions plugin;
    private Object mask = null;

    public EssentialsHook(@NotNull DMentions plugin) {
        this.plugin = plugin;
        this.pluginCondition("Essentials", ess -> {
            this.mask = ess;
        });
    }

    @Override
    public Object mask() {
        return this.mask;
    }

    private Essentials getAPI() {
        return (Essentials)this.mask;
    }

    public boolean isIgnored(@NotNull Player suspected, @NotNull Player player) {
        if (this.isMaskNull()) {
            return false;
        }
        User user = this.getAPI().getUser(player);
        return user._getIgnoredPlayers().contains(suspected.getUniqueId());
    }

    public boolean isAFK(@NotNull Player player) {
        if (this.isMaskNull()) {
            return false;
        }
        return this.getAPI().getUser(player).isAfk();
    }

    @Override
    public boolean isVanished(Player player) {
        if (this.isMaskNull() || player == null) {
            return false;
        }
        return this.getAPI().getUser(player).isVanished();
    }

    public static class EssentialsListener
    implements Listener {
        @NotNull
        private final DMentions plugin;

        public EssentialsListener(@NotNull DMentions plugin) {
            this.plugin = plugin;
        }

        @EventHandler
        public void onVanishChange(VanishStatusChangeEvent event) {
            if (!this.plugin.getConfiguration().getConfig().getBoolean("vanish_respect", true)) {
                return;
            }
            Player player = event.getAffected().getBase();
            boolean value = event.getValue();
            if (value) {
                this.plugin.getMentionManager().removePlayer(player);
            } else {
                this.plugin.getMentionManager().addPlayer(player);
            }
            Message.VANISH_NOTIFY_X.replaceKey("{x}", String.valueOf(value)).sendMessage((CommandSender)player);
        }
    }
}

