/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.command.MainCommand;
import org.nandayo.dmentions.enumeration.MentionType;
import org.nandayo.dmentions.event.PluginEvents;
import org.nandayo.dmentions.integration.EssentialsHook;
import org.nandayo.dmentions.integration.LPEvents;
import org.nandayo.dmentions.integration.LuckPermsHook;
import org.nandayo.dmentions.integration.StaffPPHook;
import org.nandayo.dmentions.provider.VanishProvider;
import org.nandayo.dmentions.service.Config;
import org.nandayo.dmentions.service.CooldownManager;
import org.nandayo.dmentions.service.LanguageManager;
import org.nandayo.dmentions.service.MentionManager;
import org.nandayo.dmentions.service.PermissionManager;
import org.nandayo.dmentions.service.UpdateChecker;
import org.nandayo.dmentions.service.UserManager;
import org.nandayo.dmentions.service.Wrapper;
import org.nandayo.dmentions.service.message.Message;
import org.nandayo.dmentions.service.registry.GUIRegistry;
import org.nandayo.dmentions.shaded.bstats.bukkit.Metrics;
import org.nandayo.dmentions.shaded.dapi.DAPI;
import org.nandayo.dmentions.shaded.dapi.object.DEnchantment;
import org.nandayo.dmentions.shaded.dapi.object.DMaterial;
import org.nandayo.dmentions.shaded.dapi.service.YAMLRegistry;
import org.nandayo.dmentions.shaded.dapi.util.Util;
import org.nandayo.dmentions.util.DUtil;

public final class DMentions
extends JavaPlugin
implements Listener {
    private Wrapper wrapper;
    private Config configuration;
    private MentionManager mentionManager;
    private UserManager userManager;
    private CooldownManager cooldownManager;
    private LanguageManager languageManager;
    private GUIRegistry guiRegistry;
    private PermissionManager permissionManager = null;
    private Player guiConfigEditor = null;
    private EssentialsHook essentialsHook;
    private LuckPermsHook luckPermsHook;
    private StaffPPHook staffPPHook;
    private VanishProvider vanishProvider;
    private static DMentions plugin;

    public static DMentions inst() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)this);
        pm.registerEvents((Listener)PluginEvents.INSTANCE, (Plugin)this);
        Objects.requireNonNull(this.getCommand("dmentions")).setExecutor((CommandExecutor)new MainCommand());
        this.setupDAPI();
        this.setupIntegrations();
        this.updateVariables();
        this.setupProviders();
        UpdateChecker.INSTANCE.check(this);
        new Metrics((Plugin)this, 24381);
    }

    public void onDisable() {
        this.userManager.saveChanges();
    }

    private void setupDAPI() {
        DAPI.registerMenuListener();
        Util.PREFIX = "&7[&eDMentions&7]&r ";
    }

    private void setupIntegrations() {
        this.luckPermsHook = new LuckPermsHook(this);
        if (!this.luckPermsHook.isMaskNull()) {
            new LPEvents(plugin, this.luckPermsHook).register();
            Util.log("&aLuckPerms integration has been enabled. Make sure you are using v5.1 or newer.");
        }
        this.essentialsHook = new EssentialsHook(this);
        if (!this.essentialsHook.isMaskNull()) {
            Bukkit.getPluginManager().registerEvents((Listener)new EssentialsHook.EssentialsListener(this), (Plugin)this);
            Util.log("&aEssentialsX integration has been enabled. Make sure you are using v2.19.2 or newer.");
        }
        this.staffPPHook = new StaffPPHook(this);
        if (!this.staffPPHook.isMaskNull()) {
            Bukkit.getPluginManager().registerEvents((Listener)new StaffPPHook.StaffPlusPlusListener(this), (Plugin)this);
            Util.log("&aStaff++ integration has been enabled.");
        }
    }

    public void updateVariables() {
        this.wrapper = new Wrapper(this);
        this.configuration = new Config(this).updateConfig();
        this.mentionManager = new MentionManager(this);
        if (this.userManager != null) {
            this.userManager.saveChanges();
        }
        this.userManager = new UserManager(this);
        this.cooldownManager = new CooldownManager(this);
        this.cooldownManager.updateConfigCooldowns();
        this.languageManager = new LanguageManager(this, this.configuration.getConfig().getString("lang_file", "en-US"));
        this.guiRegistry = new GUIRegistry(this).updateConfiguration();
        YAMLRegistry.loadRegistries();
        Message.init(this.languageManager);
        if (this.permissionManager == null) {
            this.permissionManager = new PermissionManager(this);
            this.permissionManager.clearAfterLoadPermissions();
            this.permissionManager.setupPermissions();
        }
    }

    private void setupProviders() {
        String vanishProvider = this.configuration.getConfig().getString("vanish_provider", "auto");
        boolean isAuto = vanishProvider.equals("auto");
        if (!this.staffPPHook.isMaskNull() && (isAuto || vanishProvider.equalsIgnoreCase("staff++"))) {
            this.vanishProvider = this.staffPPHook;
            Util.log("&aUsing Staff++ as VanishProvider.");
        } else if (!this.essentialsHook.isMaskNull() && (isAuto || vanishProvider.equalsIgnoreCase("essentials"))) {
            this.vanishProvider = this.essentialsHook;
            Util.log("&aUsing EssentialsX as VanishProvider.");
        } else {
            this.vanishProvider = player -> false;
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.mentionManager.addPlayer(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.mentionManager.removePlayer(event.getPlayer());
        this.cooldownManager.removeCooldown(MentionType.PLAYER, event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChat(AsyncPlayerChatEvent e) {
        String worldName;
        Player sender = e.getPlayer();
        String message = e.getMessage();
        List disabledWorlds = this.configuration.getConfig().getStringList("disabled_worlds");
        if (disabledWorlds.contains(worldName = sender.getWorld().getName())) {
            Message.DISABLED_WORLD_WARN.replaceValue("{world}", worldName).sendMessage((CommandSender)sender);
            return;
        }
        String mentionedString = this.mentionManager.getMentionedString(this, sender, message);
        e.setMessage(mentionedString);
    }

    @Deprecated(since="1.8.3", forRemoval=true)
    public Material getMaterial(@NotNull DMaterial dMaterial, @NotNull DMaterial def) {
        return DUtil.getMaterial(dMaterial, def);
    }

    @Deprecated(since="1.8.3", forRemoval=true)
    public Enchantment getEnchantment(@NotNull DEnchantment dEnchantment, @NotNull DEnchantment def) {
        return DUtil.getEnchantment(dEnchantment, def);
    }

    @Deprecated(since="1.8.3", forRemoval=true)
    public boolean isRestricted(@NotNull Player sender, @NotNull Player target) {
        return DUtil.isRestricted(sender, target);
    }

    @Deprecated(since="1.8.3", forRemoval=true)
    @Nullable
    public ConfigurationSection getConfigGroupSection(String groupName) {
        return DUtil.getGroupConfigSection(groupName);
    }

    @Deprecated(since="1.8.3", forRemoval=true)
    @Nullable
    public ConfigurationSection getLanguageGroupSection(String groupName) {
        return DUtil.getGroupLanguageSection(groupName);
    }

    @Deprecated(since="1.8.3", forRemoval=true)
    @NotNull
    public String getGroupConfigTitle(@Nullable String groupName) {
        return DUtil.getGroupConfigKey(groupName);
    }

    @Deprecated(since="1.8.3", forRemoval=true)
    @NotNull
    public String getPermission(String str) {
        return str == null ? "" : str;
    }

    @Deprecated(since="1.8.3", forRemoval=true)
    @NotNull
    public String formattedTime(long millisecond) {
        return DUtil.formattedTime(millisecond);
    }

    @Deprecated(since="1.8.3", forRemoval=true)
    public int parseInt(String str) {
        return DUtil.parseInt(str, 0);
    }

    @Generated
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Generated
    public Config getConfiguration() {
        return this.configuration;
    }

    @Generated
    public MentionManager getMentionManager() {
        return this.mentionManager;
    }

    @Generated
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Generated
    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    @Generated
    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    @Generated
    public GUIRegistry getGuiRegistry() {
        return this.guiRegistry;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public Player getGuiConfigEditor() {
        return this.guiConfigEditor;
    }

    @Generated
    public EssentialsHook getEssentialsHook() {
        return this.essentialsHook;
    }

    @Generated
    public LuckPermsHook getLuckPermsHook() {
        return this.luckPermsHook;
    }

    @Generated
    public StaffPPHook getStaffPPHook() {
        return this.staffPPHook;
    }

    @Generated
    public VanishProvider getVanishProvider() {
        return this.vanishProvider;
    }

    @Generated
    public void setGuiConfigEditor(Player guiConfigEditor) {
        this.guiConfigEditor = guiConfigEditor;
    }
}

