/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.util.Locale;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.Util;
import org.nandayo.dmentions.DMentions;

public class Wrapper {
    private final DMentions plugin;
    private final int version;

    public Wrapper(DMentions plugin) {
        this.plugin = plugin;
        this.version = this.fetchVersion();
    }

    private int fetchVersion() {
        int version;
        CharSequence[] ver = Bukkit.getBukkitVersion().split("-")[0].split("\\.");
        if (ver.length < 2) {
            Util.log("&cCould not fetch server version!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
        int major = 0;
        try {
            major = Integer.parseInt(ver[1]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int minor = 0;
        if (ver.length >= 3) {
            try {
                minor = Integer.parseInt(ver[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((version = major * 10 + minor) < 165) {
            Util.log(String.format("&cYou are using an unsupported server version '%s'!", String.join((CharSequence)".", ver)), "&cPlease use v1.16.5 or newer.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
        return version;
    }

    @Nullable
    public Sound getSound(@NotNull String soundName) {
        return (Sound)Registry.SOUNDS.get(NamespacedKey.minecraft((String)soundName.toLowerCase(Locale.ENGLISH)));
    }

    public void playSound(@NotNull Player player, @NotNull Sound sound) {
        if (this.version >= 181) {
            player.playSound((Entity)player, sound, 0.6f, 1.0f);
        } else {
            player.playSound(player.getLocation(), sound, 0.6f, 1.0f);
        }
    }

    @Generated
    public DMentions getPlugin() {
        return this.plugin;
    }

    @Generated
    public int getVersion() {
        return this.version;
    }
}

