/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.message.ChannelTitleMessage;
import org.nandayo.dapi.message.ChannelType;
import org.nandayo.dmentions.DMentions;

public class MessageManager {
    public static void sendSortedMessage(@NotNull Player player, String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        String[] parts = msg.split("=");
        if (parts.length < 2) {
            MessageManager.sendMessage(player, msg);
        }
        switch (parts[0]) {
            case "CHAT": {
                MessageManager.sendMessage(player, parts[1]);
                break;
            }
            case "ACTION_BAR": {
                MessageManager.sendActionBar(player, parts[1]);
                break;
            }
            case "TITLE": {
                MessageManager.sendTitle(player, parts[1]);
            }
        }
    }

    public static void sendMessage(@NotNull Player player, String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        ChannelType.CHAT.send((CommandSender)player, MessageManager.prefixedString(msg));
    }

    public static void sendActionBar(@NotNull Player player, String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        ChannelType.ACTION_BAR.send((CommandSender)player, MessageManager.prefixedString(msg));
    }

    public static void sendTitle(@NotNull Player player, String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        String[] lines = msg.split("\\|\\|");
        String title = MessageManager.prefixedString(lines[0]);
        String subtitle = lines.length > 1 ? MessageManager.prefixedString(lines[1]) : "";
        ChannelType.TITLE_AND_SUBTITLE.send((CommandSender)player, new ChannelTitleMessage(title, subtitle));
    }

    private static String prefixedString(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        String prefix = DMentions.inst().getConfiguration().getConfig().getString("prefix", "");
        return str.replaceAll("\\{PREFIX}", prefix);
    }
}

