/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dapi.Util;
import org.nandayo.dmentions.DMentions;

public class Config {
    private FileConfiguration config;
    private FileConfiguration unsavedConfig;
    @NotNull
    private final DMentions plugin;

    public Config(@NotNull DMentions plugin) {
        this.plugin = plugin;
        File file = new File(this.plugin.getDataFolder(), "config.yml");
        if (!file.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
        this.resetUnsavedConfig();
    }

    public Config updateConfig() {
        if (this.compareVersions()) {
            return this;
        }
        FileConfiguration defConfig = this.getSourceConfiguration();
        if (defConfig == null) {
            return this;
        }
        this.saveBackupConfig();
        for (String key : defConfig.getKeys(true)) {
            if (key.startsWith("suffix_color.group") || key.startsWith("disabled_worlds") || key.startsWith("group.disabled_groups") || key.startsWith("group.list") || defConfig.isConfigurationSection(key) || !this.config.contains(key)) continue;
            defConfig.set(key, this.config.get(key));
        }
        this.handleSpecialCases(defConfig);
        defConfig.set("config_version", (Object)this.plugin.getDescription().getVersion());
        this.config = defConfig;
        this.resetUnsavedConfig();
        try {
            this.config.save(new File(this.plugin.getDataFolder(), "config.yml"));
            Util.log("&aUpdated config file.");
        }
        catch (IOException e) {
            Util.log("&cFailed to save updated config file.");
            e.printStackTrace();
        }
        return this;
    }

    private boolean compareVersions() {
        String pluginVersion = this.plugin.getDescription().getVersion();
        String configVersion = this.config.getString("config_version", "0");
        return pluginVersion.equals(configVersion);
    }

    private FileConfiguration getSourceConfiguration() {
        InputStream defStream = this.plugin.getResource("config.yml");
        if (defStream == null) {
            Util.log("&cDefault config.yml not found in plugin resources.");
            return null;
        }
        return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream));
    }

    private void saveBackupConfig() {
        File backupDir = new File(this.plugin.getDataFolder(), "backups");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        String date = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        File backupFile = new File(backupDir, "config_" + date + ".yml");
        try {
            this.config.save(backupFile);
            Util.log("&aBacked up old config file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save old config backup file.");
            e.printStackTrace();
        }
    }

    private void handleSpecialCases(@NotNull FileConfiguration defConfig) {
        defConfig.set("suffix_color.group", null);
        ConfigurationSection suffixSection = this.config.getConfigurationSection("suffix_color.group");
        if (suffixSection != null) {
            for (String group : suffixSection.getKeys(true)) {
                defConfig.set(suffixSection.getCurrentPath() + "." + group, (Object)suffixSection.getString(group));
            }
        }
        defConfig.set("disabled_worlds", (Object)this.config.getStringList("disabled_worlds"));
        defConfig.set("group.disabled_groups", (Object)this.config.getStringList("group.disabled_groups"));
        ConfigurationSection groupSection = this.config.getConfigurationSection("group.list");
        ConfigurationSection keySection = defConfig.getConfigurationSection("group.list.default");
        Set keys = keySection != null ? keySection.getKeys(true) : new HashSet();
        defConfig.set("group.list", null);
        if (groupSection != null) {
            for (String group : groupSection.getKeys(false)) {
                for (String key : keys) {
                    if (this.config.isConfigurationSection(group + "." + key)) continue;
                    defConfig.set(groupSection.getCurrentPath() + "." + group + "." + key, groupSection.get(group + "." + key));
                }
            }
        }
    }

    public void resetUnsavedConfig(CommandSender sender) {
        this.unsavedConfig = YamlConfiguration.loadConfiguration((Reader)new StringReader(this.config.saveToString()));
        if (sender != null) {
            sender.sendMessage(HexUtil.color(this.plugin.getLanguageManager().getString("command.config.reset_changes")));
        }
    }

    public void resetUnsavedConfig() {
        this.resetUnsavedConfig(null);
    }

    public void saveUnsavedConfig(CommandSender sender) {
        this.config = YamlConfiguration.loadConfiguration((Reader)new StringReader(this.unsavedConfig.saveToString()));
        if (sender != null) {
            sender.sendMessage(HexUtil.color(this.plugin.getLanguageManager().getString("command.config.save_changes")));
            Util.log("&eUpdated config keys in-game by player " + sender.getName() + ".");
        }
        try {
            this.config.save(new File(this.plugin.getDataFolder(), "config.yml"));
            this.plugin.updateVariables();
        }
        catch (IOException e) {
            Util.log("&cFailed to save old config file.");
        }
    }

    public void saveUnsavedConfig() {
        this.saveUnsavedConfig(null);
    }

    public boolean isValueChanged(@NotNull String path) {
        return !Objects.equals(this.config.get(path), this.unsavedConfig.get(path));
    }

    public String getValueDisplayMessage(@NotNull String message, @NotNull String configPath) {
        return message.replace("{value}", this.config.getString(configPath, "")).replace("{unsaved_value}", this.unsavedConfig.getString(configPath, ""));
    }

    @Generated
    public FileConfiguration getConfig() {
        return this.config;
    }

    @Generated
    public FileConfiguration getUnsavedConfig() {
        return this.unsavedConfig;
    }

    @NotNull
    @Generated
    public DMentions getPlugin() {
        return this.plugin;
    }
}

