/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.LP;
import org.nandayo.dmentions.menu.AnvilManager;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;

public class SubSuffixMenu
extends BaseMenu {
    public SubSuffixMenu(@NotNull DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.open();
    }

    @Override
    void open() {
        int slot;
        final ConfigurationSection menuSection = this.LANGUAGE_MANAGER.getSection("menu.suffix_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.LANGUAGE_MANAGER.getString(menuSection, "title"));
        int i = 0;
        ConfigurationSection section = this.config.getUnsavedConfig().getConfigurationSection("suffix_color.group");
        if (section != null) {
            for (final String suffixGroup : section.getKeys(false)) {
                slot = i++;
                this.addButton(new Button(){
                    final String configPath;
                    final String changed;
                    final String langPathName = "existent_group";
                    {
                        this.configPath = "suffix_color.group." + suffixGroup;
                        this.changed = SubSuffixMenu.this.config.isValueChanged(this.configPath) ? "changed" : "unchanged";
                        this.langPathName = "existent_group";
                    }

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Sets.newHashSet((Object[])new Integer[]{slot});
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.GREEN_BANNER).name(SubSuffixMenu.this.LANGUAGE_MANAGER.getString(menuSection, "existent_group.display_name").replace("{group}", suffixGroup)).lore(() -> {
                            ArrayList<String> lore = new ArrayList<String>();
                            for (String line : SubSuffixMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "existent_group.lore." + this.changed)) {
                                lore.add(SubSuffixMenu.this.config.getValueDisplayMessage(line, this.configPath));
                            }
                            return lore;
                        }).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        if (clickType == ClickType.LEFT) {
                            new AnvilManager(SubSuffixMenu.this.plugin, SubSuffixMenu.this.player, this.configPath, SubSuffixMenu.this.LANGUAGE_MANAGER.getString(menuSection, "existent_group.edit_title"), text -> {
                                SubSuffixMenu.this.config.getUnsavedConfig().set(this.configPath, text);
                                new SubSuffixMenu(SubSuffixMenu.this.plugin, SubSuffixMenu.this.player);
                            });
                        } else if (clickType == ClickType.RIGHT) {
                            SubSuffixMenu.this.config.getUnsavedConfig().set(this.configPath, null);
                            new SubSuffixMenu(SubSuffixMenu.this.plugin, SubSuffixMenu.this.player);
                        }
                    }
                });
            }
        }
        i = i - i % 9 + 9;
        if (LP.isConnected() && section != null) {
            for (final String group : LP.getGroups()) {
                if (section.contains(group)) continue;
                slot = i++;
                this.addButton(new Button(){
                    final String langPathName = "nonexistent_group";

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Sets.newHashSet((Object[])new Integer[]{slot});
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.BLACK_BANNER).name(SubSuffixMenu.this.LANGUAGE_MANAGER.getString(menuSection, "nonexistent_group.display_name").replace("{group}", group)).lore(SubSuffixMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "nonexistent_group.lore")).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        SubSuffixMenu.this.config.getUnsavedConfig().set("suffix_color.group." + group, (Object)"&f");
                        new SubSuffixMenu(SubSuffixMenu.this.plugin, SubSuffixMenu.this.player);
                    }
                });
            }
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{45});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(SubSuffixMenu.this.LANGUAGE_MANAGER.getString("menu.back.display_name")).lore(SubSuffixMenu.this.LANGUAGE_MANAGER.getStringList("menu.back.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new GeneralSettingsMenu(SubSuffixMenu.this.plugin, SubSuffixMenu.this.player);
            }
        });
        this.runOnClose(inv -> this.plugin.setGuiConfigEditor(null));
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

