/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.enumeration.MentionType;
import org.nandayo.dmentions.integration.LP;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.MentionSettingsMenu;
import org.nandayo.dmentions.menu.MentionTypeSettingsMenu;

public class SubMentionAddGroupMenu
extends BaseMenu {
    public SubMentionAddGroupMenu(@NotNull DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.open();
    }

    @Override
    void open() {
        final ConfigurationSection menuSection = this.LANGUAGE_MANAGER.getSection("menu.add_group_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.LANGUAGE_MANAGER.getString(menuSection, "title"));
        ConfigurationSection section = this.config.getUnsavedConfig().getConfigurationSection("group.list");
        List disabledGroups = this.config.getUnsavedConfig().getStringList("group.disabled_groups");
        if (LP.isConnected() && section != null) {
            int i = 0;
            for (final String group : LP.getGroups()) {
                if (section.contains(group) || disabledGroups.contains(group)) continue;
                final int slot = i++;
                this.addButton(new Button(){
                    final String langPathName = "not_added_group";

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Sets.newHashSet((Object[])new Integer[]{slot});
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.YELLOW_BANNER).name(SubMentionAddGroupMenu.this.LANGUAGE_MANAGER.getString(menuSection, "not_added_group.display_name").replace("{group}", group)).lore(SubMentionAddGroupMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "not_added_group.lore")).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        SubMentionAddGroupMenu.this.config.getUnsavedConfig().set("group.list." + group + ".sound", (Object)"block.note_block.pling");
                        SubMentionAddGroupMenu.this.config.getUnsavedConfig().set("group.list." + group + ".display", (Object)"<#73c7dc>@{group}");
                        SubMentionAddGroupMenu.this.config.getUnsavedConfig().set("group.list." + group + ".cooldown", (Object)5);
                        new MentionTypeSettingsMenu(SubMentionAddGroupMenu.this.plugin, SubMentionAddGroupMenu.this.player, MentionType.GROUP, group);
                    }
                });
            }
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{45});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(SubMentionAddGroupMenu.this.LANGUAGE_MANAGER.getString("menu.back.display_name")).lore(SubMentionAddGroupMenu.this.LANGUAGE_MANAGER.getStringList("menu.back.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new MentionSettingsMenu(SubMentionAddGroupMenu.this.plugin, SubMentionAddGroupMenu.this.player);
            }
        });
        this.runOnClose(inv -> this.plugin.setGuiConfigEditor(null));
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

