/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;

public class SubLanguageMenu
extends BaseMenu {
    public SubLanguageMenu(@NotNull DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.open();
    }

    @Override
    void open() {
        final ConfigurationSection menuSection = this.LANGUAGE_MANAGER.getSection("menu.language_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.LANGUAGE_MANAGER.getString(menuSection, "title"));
        int i = 0;
        for (final String lang : this.LANGUAGE_MANAGER.REGISTERED_LANGUAGES) {
            final int slot = i++;
            this.addButton(new Button(){
                final String langPathName = "language";

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{slot});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.BOOK).name(SubLanguageMenu.this.LANGUAGE_MANAGER.getString(menuSection, "language.display_name").replace("{language}", lang)).lore(SubLanguageMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "language.lore")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    SubLanguageMenu.this.config.getUnsavedConfig().set("lang_file", (Object)lang);
                    new GeneralSettingsMenu(SubLanguageMenu.this.plugin, SubLanguageMenu.this.player);
                }
            });
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{45});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(SubLanguageMenu.this.LANGUAGE_MANAGER.getString("menu.back.display_name")).lore(SubLanguageMenu.this.LANGUAGE_MANAGER.getStringList("menu.back.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new GeneralSettingsMenu(SubLanguageMenu.this.plugin, SubLanguageMenu.this.player);
            }
        });
        this.runOnClose(inv -> this.plugin.setGuiConfigEditor(null));
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

