/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;

public class SubDisabledWorldsMenu
extends BaseMenu {
    public SubDisabledWorldsMenu(@NotNull DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.open();
    }

    @Override
    void open() {
        final ConfigurationSection menuSection = this.LANGUAGE_MANAGER.getSection("menu.disabled_worlds_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.LANGUAGE_MANAGER.getString(menuSection, "title"));
        int i = 0;
        final List disabledList = this.config.getUnsavedConfig().getStringList("disabled_worlds");
        for (final String world : disabledList) {
            final int slot = i++;
            this.addButton(new Button(){
                final String langPathName = "disabled_world";

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{slot});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.RED_BANNER).name(SubDisabledWorldsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "disabled_world.display_name").replace("{world}", world)).lore(SubDisabledWorldsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "disabled_world.lore")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    disabledList.remove(world);
                    SubDisabledWorldsMenu.this.config.getUnsavedConfig().set("disabled_worlds", (Object)disabledList);
                    new SubDisabledWorldsMenu(SubDisabledWorldsMenu.this.plugin, SubDisabledWorldsMenu.this.player);
                }
            });
        }
        i = i - i % 9 + 9;
        for (World w : Bukkit.getWorlds()) {
            final String world = w.getName();
            if (disabledList.contains(world)) continue;
            final int slot = i++;
            this.addButton(new Button(){
                final String langPathName = "non-disabled_world";

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{slot});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.GREEN_BANNER).name(SubDisabledWorldsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "non-disabled_world.display_name").replace("{world}", world)).lore(SubDisabledWorldsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "non-disabled_world.lore")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    disabledList.add(world);
                    SubDisabledWorldsMenu.this.config.getUnsavedConfig().set("disabled_worlds", (Object)disabledList);
                    new SubDisabledWorldsMenu(SubDisabledWorldsMenu.this.plugin, SubDisabledWorldsMenu.this.player);
                }
            });
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{45});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(SubDisabledWorldsMenu.this.LANGUAGE_MANAGER.getString("menu.back.display_name")).lore(SubDisabledWorldsMenu.this.LANGUAGE_MANAGER.getStringList("menu.back.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new GeneralSettingsMenu(SubDisabledWorldsMenu.this.plugin, SubDisabledWorldsMenu.this.player);
            }
        });
        this.runOnClose(inv -> this.plugin.setGuiConfigEditor(null));
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

