/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.LP;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.MentionSettingsMenu;

public class SubDisabledGroupsMenu
extends BaseMenu {
    public SubDisabledGroupsMenu(DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.open();
    }

    @Override
    void open() {
        int slot;
        final ConfigurationSection menuSection = this.LANGUAGE_MANAGER.getSection("menu.disabled_groups_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.LANGUAGE_MANAGER.getString(menuSection, "title"));
        int i = 0;
        final List disabledList = this.config.getUnsavedConfig().getStringList("group.disabled_groups");
        for (final String group : disabledList) {
            slot = i++;
            this.addButton(new Button(){

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{slot});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.RED_BANNER).name(SubDisabledGroupsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "disabled_group.display_name").replace("{group}", group)).lore(SubDisabledGroupsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "disabled_group.lore")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    disabledList.remove(group);
                    SubDisabledGroupsMenu.this.config.getUnsavedConfig().set("group.disabled_groups", (Object)disabledList);
                    new SubDisabledGroupsMenu(SubDisabledGroupsMenu.this.plugin, SubDisabledGroupsMenu.this.player);
                }
            });
        }
        i = i - i % 9 + 9;
        if (LP.isConnected()) {
            for (final String group : LP.getGroups()) {
                if (disabledList.contains(group)) continue;
                slot = i++;
                this.addButton(new Button(){
                    final String langPathName = "non-disabled_group";

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Sets.newHashSet((Object[])new Integer[]{slot});
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.GREEN_BANNER).name(SubDisabledGroupsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "non-disabled_group.display_name").replace("{group}", group)).lore(SubDisabledGroupsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "non-disabled_group.lore")).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        disabledList.add(group);
                        SubDisabledGroupsMenu.this.config.getUnsavedConfig().set("group.disabled_groups", (Object)disabledList);
                        new SubDisabledGroupsMenu(SubDisabledGroupsMenu.this.plugin, SubDisabledGroupsMenu.this.player);
                    }
                });
            }
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{45});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(SubDisabledGroupsMenu.this.LANGUAGE_MANAGER.getString("menu.back.display_name")).lore(SubDisabledGroupsMenu.this.LANGUAGE_MANAGER.getStringList("menu.back.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new MentionSettingsMenu(SubDisabledGroupsMenu.this.plugin, SubDisabledGroupsMenu.this.player);
            }
        });
        this.runOnClose(inv -> this.plugin.setGuiConfigEditor(null));
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

