/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.enumeration.MentionType;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.MentionSettingsMenu;
import org.nandayo.dmentions.menu.MentionTypeSettingsMenu;

public class SubChooseGroupMenu
extends BaseMenu {
    public SubChooseGroupMenu(@NotNull DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.open();
    }

    @Override
    void open() {
        final ConfigurationSection menuSection = this.LANGUAGE_MANAGER.getSection("menu.choose_group_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.LANGUAGE_MANAGER.getString(menuSection, "title"));
        int i = 0;
        ConfigurationSection section = this.config.getUnsavedConfig().getConfigurationSection("group.list");
        if (section != null) {
            for (final String group : section.getKeys(false)) {
                final int slot = i++;
                this.addButton(new Button(){

                    @Override
                    @NotNull
                    public Set<Integer> getSlots() {
                        return Sets.newHashSet((Object[])new Integer[]{slot});
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.GREEN_BANNER).name(SubChooseGroupMenu.this.LANGUAGE_MANAGER.getString(menuSection, "group.display_name").replace("{group}", group)).lore(SubChooseGroupMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "group.lore")).get();
                    }

                    @Override
                    public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                        new MentionTypeSettingsMenu(SubChooseGroupMenu.this.plugin, SubChooseGroupMenu.this.player, MentionType.GROUP, group);
                    }
                });
            }
        }
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{45});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name(SubChooseGroupMenu.this.LANGUAGE_MANAGER.getString("menu.back.display_name")).lore(SubChooseGroupMenu.this.LANGUAGE_MANAGER.getStringList("menu.back.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new MentionSettingsMenu(SubChooseGroupMenu.this.plugin, SubChooseGroupMenu.this.player);
            }
        });
        this.runOnClose(inv -> this.plugin.setGuiConfigEditor(null));
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

