/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.object.DEnchantment;
import org.nandayo.dapi.object.DMaterial;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.enumeration.MentionType;
import org.nandayo.dmentions.menu.AnvilManager;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;
import org.nandayo.dmentions.menu.MentionSettingsMenu;
import org.nandayo.dmentions.menu.SubDisabledGroupsMenu;
import org.nandayo.dmentions.menu.SubMentionAddGroupMenu;

public class MentionTypeSettingsMenu
extends BaseMenu {
    private final List<String> insiderVar = Arrays.asList("sound", "display", "cooldown");
    @NotNull
    private final MentionType mentionType;
    @Nullable
    private final String group;

    public MentionTypeSettingsMenu(@NotNull DMentions plugin, @NotNull Player player, @NotNull MentionType mentionType, @Nullable String group) {
        super(plugin, player);
        this.mentionType = mentionType;
        this.group = group;
        this.open();
    }

    @Override
    void open() {
        final ConfigurationSection menuSection = this.LANGUAGE_MANAGER.getSection("menu.mention_type_settings_menu");
        final String langMentionKey = this.mentionType == MentionType.GROUP ? "group" : "other";
        this.createInventory(MenuType.CHEST_6_ROWS, this.LANGUAGE_MANAGER.getString(menuSection, "title." + langMentionKey).replace("{mentionType}", this.mentionType.name().toLowerCase(Locale.ENGLISH)).replace("{group}", this.group == null ? "?" : this.group));
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{1, 10, 19, 28, 37, 46});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GRAY_STAINED_GLASS_PANE).name(" ").get();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{9});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.COMPASS).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.general_button.display_name")).lore(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.general_button.lore.not_viewing")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new GeneralSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{27});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(MentionTypeSettingsMenu.this.mentionType.getIconMaterial()).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.mention_button.display_name")).lore(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.mention_button.lore.go_back")).enchant(MentionTypeSettingsMenu.this.plugin.getEnchantment(DEnchantment.UNBREAKING, DEnchantment.DURABILITY), 1).hideFlag(ItemFlag.values()).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new MentionSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{47});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BARRIER).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.reset_changes.display_name")).lore(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.reset_changes.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                MentionTypeSettingsMenu.this.config.resetUnsavedConfig((CommandSender)p);
                MentionTypeSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{53});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.WRITABLE_BOOK).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.save_changes.display_name")).lore(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.save_changes.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                MentionTypeSettingsMenu.this.config.saveUnsavedConfig((CommandSender)p);
                MentionTypeSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(){
            final String configPath;
            final String changed;
            final String langPathName = "enabled";
            {
                this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "enabled", MentionTypeSettingsMenu.this.group);
                this.changed = MentionTypeSettingsMenu.this.config.isValueChanged(this.configPath) ? "changed" : "unchanged";
                this.langPathName = "enabled";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.LEVER).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "enabled.display_name." + langMentionKey)).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "enabled.lore." + this.changed)) {
                        lore.add(MentionTypeSettingsMenu.this.config.getValueDisplayMessage(line, this.configPath));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, this.configPath, MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "enabled.edit_title"), text -> {
                    MentionTypeSettingsMenu.this.config.getUnsavedConfig().set(this.configPath, (Object)Boolean.parseBoolean(text));
                    new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                });
            }
        });
        this.addButton(new Button(){
            final String configPath;
            final String changed;
            final String langPathName = "permission";
            {
                this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "permission", MentionTypeSettingsMenu.this.group);
                this.changed = MentionTypeSettingsMenu.this.config.isValueChanged(this.configPath) ? "changed" : "unchanged";
                this.langPathName = "permission";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{14});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.PAPER).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "permission.display_name." + langMentionKey)).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "permission.lore." + this.changed)) {
                        lore.add(MentionTypeSettingsMenu.this.config.getValueDisplayMessage(line, this.configPath));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, this.configPath, MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "permission.edit_title"), text -> {
                    MentionTypeSettingsMenu.this.config.getUnsavedConfig().set(this.configPath, text);
                    new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                });
            }
        });
        this.addButton(new Button(){
            final String configPath;
            final String changed;
            final String langPathName = "sound";
            {
                this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "sound", MentionTypeSettingsMenu.this.group);
                this.changed = MentionTypeSettingsMenu.this.config.isValueChanged(this.configPath) ? "changed" : "unchanged";
                this.langPathName = "sound";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.NOTE_BLOCK).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "sound.display_name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "sound.lore." + this.changed)) {
                        lore.add(MentionTypeSettingsMenu.this.config.getValueDisplayMessage(line, this.configPath));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, this.configPath, MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "sound.edit_title"), text -> {
                    MentionTypeSettingsMenu.this.config.getUnsavedConfig().set(this.configPath, text);
                    new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                });
            }
        });
        if (this.mentionType != MentionType.PLAYER) {
            this.addButton(new Button(){
                final String configPath;
                final String changed;
                final String langPathName = "keyword";
                {
                    this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "keyword", MentionTypeSettingsMenu.this.group);
                    this.changed = MentionTypeSettingsMenu.this.config.isValueChanged(this.configPath) ? "changed" : "unchanged";
                    this.langPathName = "keyword";
                }

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{30});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.NAME_TAG).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "keyword.display_name." + langMentionKey)).lore(() -> {
                        ArrayList<String> lore = new ArrayList<String>();
                        for (String line : MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "keyword.lore." + this.changed)) {
                            lore.add(MentionTypeSettingsMenu.this.config.getValueDisplayMessage(line, this.configPath));
                        }
                        return lore;
                    }).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, this.configPath, MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "keyword.edit_title"), text -> {
                        MentionTypeSettingsMenu.this.config.getUnsavedConfig().set(this.configPath, text);
                        new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                    });
                }
            });
        }
        this.addButton(new Button(){
            final String configPath;
            final String changed;
            final String langPathName = "display";
            {
                this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "display", MentionTypeSettingsMenu.this.group);
                this.changed = MentionTypeSettingsMenu.this.config.isValueChanged(this.configPath) ? "changed" : "unchanged";
                this.langPathName = "display";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{32});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ITEM_FRAME).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "display.display_name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "display.lore." + this.changed)) {
                        lore.add(MentionTypeSettingsMenu.this.config.getValueDisplayMessage(line, this.configPath));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, this.configPath, MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "display.edit_title"), text -> {
                    MentionTypeSettingsMenu.this.config.getUnsavedConfig().set(this.configPath, text);
                    new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                });
            }
        });
        this.addButton(new Button(){
            final String configPath;
            final String changed;
            final String langPathName = "cooldown";
            {
                this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "cooldown", MentionTypeSettingsMenu.this.group);
                this.changed = MentionTypeSettingsMenu.this.config.isValueChanged(this.configPath) ? "changed" : "unchanged";
                this.langPathName = "cooldown";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{34});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CLOCK).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "cooldown.display_name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "cooldown.lore." + this.changed)) {
                        lore.add(MentionTypeSettingsMenu.this.config.getValueDisplayMessage(line, this.configPath));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, this.configPath, MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "cooldown.edit_title"), text -> {
                    MentionTypeSettingsMenu.this.config.getUnsavedConfig().set(this.configPath, (Object)MentionTypeSettingsMenu.this.plugin.parseInt((String)text));
                    new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                });
            }
        });
        if (this.mentionType == MentionType.PLAYER) {
            this.addButton(new Button(){
                final String configPath;
                final String changed;
                final String langPathName = "customized_display";
                {
                    this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "customized_display", MentionTypeSettingsMenu.this.group);
                    this.changed = MentionTypeSettingsMenu.this.config.isValueChanged(this.configPath) ? "changed" : "unchanged";
                    this.langPathName = "customized_display";
                }

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{51});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(MentionTypeSettingsMenu.this.plugin.getMaterial(DMaterial.GLOW_ITEM_FRAME, DMaterial.PAINTING)).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "customized_display.display_name")).lore(() -> {
                        ArrayList<String> lore = new ArrayList<String>();
                        for (String line : MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "customized_display.lore." + this.changed)) {
                            lore.add(MentionTypeSettingsMenu.this.config.getValueDisplayMessage(line, this.configPath));
                        }
                        return lore;
                    }).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, this.configPath, MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "customized_display.edit_title"), text -> {
                        MentionTypeSettingsMenu.this.config.getUnsavedConfig().set(this.configPath, text);
                        new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                    });
                }
            });
        } else if (this.mentionType == MentionType.GROUP) {
            this.addButton(new Button(){
                final String langPathName = "add_delete_group";

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{51});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.BLACK_BANNER).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "add_delete_group.display_name")).lore(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "add_delete_group.lore")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    if (clickType == ClickType.LEFT) {
                        new SubMentionAddGroupMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player);
                    } else if (clickType == ClickType.RIGHT) {
                        MentionTypeSettingsMenu.this.config.getUnsavedConfig().set("group.list." + MentionTypeSettingsMenu.this.group, null);
                        new MentionSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player);
                    }
                }
            });
            this.addButton(new Button(){
                final String langPathName = "disabled_groups";

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{49});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.REDSTONE).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "disabled_groups.display_name")).lore(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "disabled_groups.lore")).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    new SubDisabledGroupsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player);
                }
            });
        } else if (this.mentionType == MentionType.NEARBY) {
            this.addButton(new Button(){
                final String configPath;
                final String changed;
                final String langPathName = "radius";
                {
                    this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "radius", MentionTypeSettingsMenu.this.group);
                    this.changed = MentionTypeSettingsMenu.this.config.isValueChanged(this.configPath) ? "changed" : "unchanged";
                    this.langPathName = "radius";
                }

                @Override
                @NotNull
                public Set<Integer> getSlots() {
                    return Sets.newHashSet((Object[])new Integer[]{51});
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.ENDER_PEARL).name(MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "radius.display_name")).lore(() -> {
                        ArrayList<String> lore = new ArrayList<String>();
                        for (String line : MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "radius.lore." + this.changed)) {
                            lore.add(MentionTypeSettingsMenu.this.config.getValueDisplayMessage(line, this.configPath));
                        }
                        return lore;
                    }).get();
                }

                @Override
                public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                    new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, this.configPath, MentionTypeSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "radius.edit_title"), text -> {
                        MentionTypeSettingsMenu.this.config.getUnsavedConfig().set(this.configPath, (Object)MentionTypeSettingsMenu.this.plugin.parseInt((String)text));
                        new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                    });
                }
            });
        }
        this.runOnClose(inv -> this.plugin.setGuiConfigEditor(null));
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }

    private String getPath(MentionType mentionType, String path, String group) {
        if (mentionType == MentionType.GROUP && this.insiderVar.contains(path)) {
            return mentionType.toString().toLowerCase() + ".list." + group + "." + path;
        }
        return mentionType.toString().toLowerCase() + "." + path;
    }
}

