/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.object.DEnchantment;
import org.nandayo.dapi.object.DMaterial;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.enumeration.MentionType;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;
import org.nandayo.dmentions.menu.MentionTypeSettingsMenu;
import org.nandayo.dmentions.menu.SubChooseGroupMenu;

public class MentionSettingsMenu
extends BaseMenu {
    public MentionSettingsMenu(@NotNull DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.open();
    }

    @Override
    void open() {
        final ConfigurationSection menuSection = this.LANGUAGE_MANAGER.getSection("menu.mention_settings_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.LANGUAGE_MANAGER.getString(menuSection, "title"));
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{1, 10, 19, 28, 37, 46});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GRAY_STAINED_GLASS_PANE).name(" ").get();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{9});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.COMPASS).name(MentionSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.general_button.display_name")).lore(MentionSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.general_button.lore.not_viewing")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new GeneralSettingsMenu(MentionSettingsMenu.this.plugin, MentionSettingsMenu.this.player);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{27});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BELL).name(MentionSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.mention_button.display_name")).lore(MentionSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.mention_button.lore.viewing")).enchant(MentionSettingsMenu.this.plugin.getEnchantment(DEnchantment.UNBREAKING, DEnchantment.DURABILITY), 1).hideFlag(ItemFlag.values()).get();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{47});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BARRIER).name(MentionSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.reset_changes.display_name")).lore(MentionSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.reset_changes.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                MentionSettingsMenu.this.config.resetUnsavedConfig((CommandSender)p);
                MentionSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{53});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.WRITABLE_BOOK).name(MentionSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.save_changes.display_name")).lore(MentionSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.save_changes.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                MentionSettingsMenu.this.config.saveUnsavedConfig((CommandSender)p);
                MentionSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(){
            final String langPathName = "player_mentions";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.PLAYER_HEAD).name(MentionSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "player_mentions.display_name")).lore(MentionSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "player_mentions.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new MentionTypeSettingsMenu(MentionSettingsMenu.this.plugin, MentionSettingsMenu.this.player, MentionType.PLAYER, null);
            }
        });
        this.addButton(new Button(){
            final String langPathName = "everyone_mentions";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{14});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BEACON).name(MentionSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "everyone_mentions.display_name")).lore(MentionSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "everyone_mentions.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new MentionTypeSettingsMenu(MentionSettingsMenu.this.plugin, MentionSettingsMenu.this.player, MentionType.EVERYONE, null);
            }
        });
        this.addButton(new Button(){
            final String langPathName = "nearby_mentions";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(MentionSettingsMenu.this.plugin.getMaterial(DMaterial.SPYGLASS, DMaterial.TARGET)).name(MentionSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "nearby_mentions.display_name")).lore(MentionSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "nearby_mentions.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new MentionTypeSettingsMenu(MentionSettingsMenu.this.plugin, MentionSettingsMenu.this.player, MentionType.NEARBY, null);
            }
        });
        this.addButton(new Button(){
            final String langPathName = "group_mentions";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{30});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GREEN_BANNER).name(MentionSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "group_mentions.display_name")).lore(MentionSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "group_mentions.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new SubChooseGroupMenu(MentionSettingsMenu.this.plugin, MentionSettingsMenu.this.player);
            }
        });
        this.runOnClose(inv -> this.plugin.setGuiConfigEditor(null));
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

