/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.object.DEnchantment;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.menu.AnvilManager;
import org.nandayo.dmentions.menu.BaseMenu;
import org.nandayo.dmentions.menu.MentionSettingsMenu;
import org.nandayo.dmentions.menu.SubDisabledWorldsMenu;
import org.nandayo.dmentions.menu.SubLanguageMenu;
import org.nandayo.dmentions.menu.SubSuffixMenu;

public class GeneralSettingsMenu
extends BaseMenu {
    public GeneralSettingsMenu(@NotNull DMentions plugin, @NotNull Player player) {
        super(plugin, player);
        this.open();
    }

    @Override
    void open() {
        final ConfigurationSection menuSection = this.LANGUAGE_MANAGER.getSection("menu.general_settings_menu");
        this.createInventory(MenuType.CHEST_6_ROWS, this.LANGUAGE_MANAGER.getString(menuSection, "title"));
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{1, 10, 19, 28, 37, 46});
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.GRAY_STAINED_GLASS_PANE).name(" ").get();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{9});
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemCreator.of(Material.COMPASS).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.general_button.display_name")).lore(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.general_button.lore.viewing")).enchant(GeneralSettingsMenu.this.plugin.getEnchantment(DEnchantment.UNBREAKING, DEnchantment.DURABILITY), 1).hideFlag(ItemFlag.values()).get();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{27});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BELL).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.mention_button.display_name")).lore(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.mention_button.lore.not_viewing")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new MentionSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player);
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{47});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BARRIER).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.reset_changes.display_name")).lore(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.reset_changes.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                GeneralSettingsMenu.this.config.resetUnsavedConfig((CommandSender)p);
                GeneralSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(){

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{53});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.WRITABLE_BOOK).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString("menu.save_changes.display_name")).lore(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList("menu.save_changes.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                GeneralSettingsMenu.this.config.saveUnsavedConfig((CommandSender)p);
                GeneralSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(){
            final String configPath = "lang_file";
            final String changed;
            final String langPathName = "language";
            {
                this.changed = GeneralSettingsMenu.this.config.isValueChanged("lang_file") ? "changed" : "unchanged";
                this.langPathName = "language";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{12});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BOOK).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "language.display_name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "language.lore." + this.changed)) {
                        lore.add(GeneralSettingsMenu.this.config.getValueDisplayMessage(line, "lang_file"));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new SubLanguageMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player);
            }
        });
        this.addButton(new Button(){
            final String configPath = "check_for_updates";
            final String changed;
            final String langPathName = "check_for_updates";
            {
                this.changed = GeneralSettingsMenu.this.config.isValueChanged("check_for_updates") ? "changed" : "unchanged";
                this.langPathName = "check_for_updates";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{13});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CLOCK).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "check_for_updates.display_name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "check_for_updates.lore." + this.changed)) {
                        lore.add(GeneralSettingsMenu.this.config.getValueDisplayMessage(line, "check_for_updates"));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, "check_for_updates", GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "check_for_updates.edit_title"), text -> {
                    GeneralSettingsMenu.this.config.getUnsavedConfig().set("check_for_updates", (Object)Boolean.parseBoolean(text));
                    new GeneralSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player);
                });
            }
        });
        this.addButton(new Button(){
            final String configPath = "prefix";
            final String changed;
            final String langPathName = "prefix";
            {
                this.changed = GeneralSettingsMenu.this.config.isValueChanged("prefix") ? "changed" : "unchanged";
                this.langPathName = "prefix";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{14});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.NAME_TAG).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "prefix.display_name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "prefix.lore." + this.changed)) {
                        lore.add(GeneralSettingsMenu.this.config.getValueDisplayMessage(line, "prefix"));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, "prefix", GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "prefix.edit_title"), text -> {
                    GeneralSettingsMenu.this.config.getUnsavedConfig().set("prefix", text);
                    new GeneralSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player);
                });
            }
        });
        this.addButton(new Button(){
            final String configPath = "mention_limit";
            final String changed;
            final String langPathName = "mention_limit";
            {
                this.changed = GeneralSettingsMenu.this.config.isValueChanged("mention_limit") ? "changed" : "unchanged";
                this.langPathName = "mention_limit";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{15});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.PAPER).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "mention_limit.display_name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "mention_limit.lore." + this.changed)) {
                        lore.add(GeneralSettingsMenu.this.config.getValueDisplayMessage(line, "mention_limit"));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, "mention_limit", GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "mention_limit.edit_title"), text -> {
                    GeneralSettingsMenu.this.config.getUnsavedConfig().set("mention_limit", (Object)GeneralSettingsMenu.this.plugin.parseInt((String)text));
                    new GeneralSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player);
                });
            }
        });
        this.addButton(new Button(){
            final String configPath = "vanish_respect";
            final String changed;
            final String langPathName = "vanish_respect";
            {
                this.changed = GeneralSettingsMenu.this.config.isValueChanged("vanish_respect") ? "changed" : "unchanged";
                this.langPathName = "vanish_respect";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{16});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.POTION).potion(PotionType.INVISIBILITY).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "vanish_respect.display_name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "vanish_respect.lore." + this.changed)) {
                        lore.add(GeneralSettingsMenu.this.config.getValueDisplayMessage(line, "vanish_respect"));
                    }
                    return lore;
                }).hideFlag(ItemFlag.values()).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, "vanish_respect", GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "vanish_respect.edit_title"), text -> {
                    GeneralSettingsMenu.this.config.getUnsavedConfig().set("vanish_respect", (Object)Boolean.parseBoolean(text));
                    new GeneralSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player);
                });
            }
        });
        this.addButton(new Button(){
            final String configPath = "afk_respect";
            final String changed;
            final String langPathName = "afk_respect";
            {
                this.changed = GeneralSettingsMenu.this.config.isValueChanged("afk_respect") ? "changed" : "unchanged";
                this.langPathName = "afk_respect";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{30});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.PACKED_ICE).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "afk_respect.display_name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "afk_respect.lore." + this.changed)) {
                        lore.add(GeneralSettingsMenu.this.config.getValueDisplayMessage(line, "afk_respect"));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, "afk_respect", GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "afk_respect.edit_title"), text -> {
                    GeneralSettingsMenu.this.config.getUnsavedConfig().set("afk_respect", (Object)Boolean.parseBoolean(text));
                    new GeneralSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player);
                });
            }
        });
        this.addButton(new Button(){
            final String configPath = "ignore_respect";
            final String changed;
            final String langPathName = "ignore_respect";
            {
                this.changed = GeneralSettingsMenu.this.config.isValueChanged("ignore_respect") ? "changed" : "unchanged";
                this.langPathName = "ignore_respect";
            }

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{31});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ENDER_EYE).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "ignore_respect.display_name")).lore(() -> {
                    ArrayList<String> lore = new ArrayList<String>();
                    for (String line : GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "ignore_respect.lore." + this.changed)) {
                        lore.add(GeneralSettingsMenu.this.config.getValueDisplayMessage(line, "ignore_respect"));
                    }
                    return lore;
                }).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new AnvilManager(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, "ignore_respect", GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "ignore_respect.edit_title"), text -> {
                    GeneralSettingsMenu.this.config.getUnsavedConfig().set("ignore_respect", (Object)Boolean.parseBoolean(text));
                    new GeneralSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player);
                });
            }
        });
        this.addButton(new Button(){
            final String langPathName = "suffix_colors";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{32});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CYAN_DYE).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "suffix_colors.display_name")).lore(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "suffix_colors.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new SubSuffixMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player);
            }
        });
        this.addButton(new Button(){
            final String langPathName = "disabled_worlds";

            @Override
            @NotNull
            public Set<Integer> getSlots() {
                return Sets.newHashSet((Object[])new Integer[]{33});
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GRASS_BLOCK).name(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getString(menuSection, "disabled_worlds.display_name")).lore(GeneralSettingsMenu.this.LANGUAGE_MANAGER.getStringList(menuSection, "disabled_worlds.lore")).get();
            }

            @Override
            public void onClick(@NotNull Player p, @NotNull ClickType clickType) {
                new SubDisabledWorldsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player);
            }
        });
        this.runOnClose(inv -> this.plugin.setGuiConfigEditor(null));
        this.displayTo(this.player);
        this.plugin.setGuiConfigEditor(this.player);
    }
}

