/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.integration;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class LP {
    private static LuckPerms api = null;
    private static final Map<UUID, String> playerGroupCache = new HashMap<UUID, String>();

    public LP() {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
        if (provider != null) {
            api = (LuckPerms)provider.getProvider();
        }
    }

    public static boolean isConnected() {
        return api != null;
    }

    public static List<String> getGroups() {
        if (api == null) {
            return new ArrayList<String>();
        }
        return api.getGroupManager().getLoadedGroups().stream().map(Group::getName).collect(Collectors.toList());
    }

    public static Player[] getOnlinePlayersInGroup(String groupName) {
        if (api == null || groupName == null || groupName.isEmpty()) {
            return new Player[0];
        }
        return (Player[])Bukkit.getOnlinePlayers().stream().filter(player -> {
            User user = api.getUserManager().getUser(player.getUniqueId());
            if (user == null) {
                return false;
            }
            return LP.getGroup(player).equals(groupName);
        }).toArray(Player[]::new);
    }

    public static String getGroup(Player player) {
        String group = playerGroupCache.get(player.getUniqueId());
        if (group == null) {
            LP.updatePlayerGroupCache(player);
            group = playerGroupCache.get(player.getUniqueId());
        }
        return group;
    }

    public static void updatePlayerGroupCache(Player player) {
        String group = LP.getHighestPriorityGroup(player);
        playerGroupCache.put(player.getUniqueId(), group);
    }

    private static String getHighestPriorityGroup(Player player) {
        if (api == null) {
            return "";
        }
        User user = api.getUserManager().getUser(player.getUniqueId());
        if (user == null) {
            return "";
        }
        return user.getNodes(NodeType.INHERITANCE).stream().map(InheritanceNode::getGroupName).map(groupName -> api.getGroupManager().getGroup(groupName)).filter(group -> group != null && group.getWeight().isPresent()).max(Comparator.comparingInt(group -> group.getWeight().orElse(0))).map(Group::getName).orElse(user.getPrimaryGroup());
    }

    @Generated
    public static LuckPerms getApi() {
        return api;
    }
}

