/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.integration;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.User;
import net.ess3.api.events.VanishStatusChangeEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.service.MessageManager;

public class EssentialsHook {
    private static Essentials ess = null;

    public EssentialsHook() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("Essentials");
        if (plugin instanceof Essentials) {
            ess = (Essentials)plugin;
        }
    }

    public static boolean isIgnored(@NotNull Player suspected, @NotNull Player player) {
        if (ess == null) {
            return false;
        }
        User user = ess.getUser(player);
        return user._getIgnoredPlayers().contains(suspected.getUniqueId());
    }

    public static boolean isAFK(@NotNull Player player) {
        if (ess == null) {
            return false;
        }
        return ess.getUser(player).isAfk();
    }

    public static boolean isVanished(@NotNull Player player) {
        if (ess == null) {
            return false;
        }
        return ess.getUser(player).isVanished();
    }

    public static class EssentialsListener
    implements Listener {
        @NotNull
        private final DMentions plugin;

        public EssentialsListener(@NotNull DMentions plugin) {
            this.plugin = plugin;
        }

        @EventHandler
        public void onVanishChange(VanishStatusChangeEvent event) {
            if (!this.plugin.getConfiguration().getConfig().getBoolean("vanish_respect", true)) {
                return;
            }
            Player player = event.getAffected().getBase();
            boolean value = event.getValue();
            if (value) {
                this.plugin.getMentionManager().removePlayer(player);
            } else {
                this.plugin.getMentionManager().addPlayer(player);
            }
            MessageManager.sendSortedMessage(player, this.plugin.getLanguageManager().getString("vanish_notify." + value));
        }
    }
}

