/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.event;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.event.MentionEveryoneEvent;
import org.nandayo.dmentions.event.MentionGroupEvent;
import org.nandayo.dmentions.event.MentionNearbyEvent;
import org.nandayo.dmentions.event.MentionPlayerEvent;
import org.nandayo.dmentions.integration.EssentialsHook;
import org.nandayo.dmentions.service.Config;
import org.nandayo.dmentions.service.LanguageManager;
import org.nandayo.dmentions.service.MessageManager;

public class PluginEvents
implements Listener {
    @EventHandler
    public void onPlayerMention(MentionPlayerEvent e) {
        Player sender = e.getSender();
        Player target = e.getTarget();
        Config config = DMentions.inst().getConfiguration();
        LanguageManager LANGUAGE_MANAGER = DMentions.inst().getLanguageManager();
        String soundName = config.getConfig().getString("player.sound", "");
        String targetBar = LANGUAGE_MANAGER.getString("player.action_bar.target_message").replace("{p}", sender.getName());
        String targetTitle = LANGUAGE_MANAGER.getString("player.title.target_message").replace("{p}", sender.getName());
        String senderBar = LANGUAGE_MANAGER.getString("player.action_bar.sender_message").replace("{p}", target.getName());
        String senderTitle = LANGUAGE_MANAGER.getString("player.title.sender_message").replace("{p}", target.getName());
        this.mention(sender, new Player[]{target}, soundName, targetBar, targetTitle, senderBar, senderTitle);
    }

    @EventHandler
    public void onNearbyMention(MentionNearbyEvent e) {
        Player sender = e.getSender();
        Player[] targets = e.getTargets();
        Config config = DMentions.inst().getConfiguration();
        LanguageManager LANGUAGE_MANAGER = DMentions.inst().getLanguageManager();
        String soundName = config.getConfig().getString("nearby.sound", "");
        String targetBar = LANGUAGE_MANAGER.getString("nearby.action_bar.target_message").replace("{p}", sender.getName());
        String targetTitle = LANGUAGE_MANAGER.getString("nearby.title.target_message").replace("{p}", sender.getName());
        String senderBar = LANGUAGE_MANAGER.getString("nearby.action_bar.sender_message");
        String senderTitle = LANGUAGE_MANAGER.getString("nearby.title.sender_message");
        this.mention(sender, targets, soundName, targetBar, targetTitle, senderBar, senderTitle);
    }

    @EventHandler
    public void onEveryoneMention(MentionEveryoneEvent e) {
        Player sender = e.getSender();
        Player[] targets = e.getTargets();
        Config config = DMentions.inst().getConfiguration();
        LanguageManager LANGUAGE_MANAGER = DMentions.inst().getLanguageManager();
        String soundName = config.getConfig().getString("everyone.sound", "");
        String targetBar = LANGUAGE_MANAGER.getString("everyone.action_bar.target_message").replace("{p}", sender.getName());
        String targetTitle = LANGUAGE_MANAGER.getString("everyone.title.target_message").replace("{p}", sender.getName());
        String senderBar = LANGUAGE_MANAGER.getString("everyone.action_bar.sender_message");
        String senderTitle = LANGUAGE_MANAGER.getString("everyone.title.sender_message");
        this.mention(sender, targets, soundName, targetBar, targetTitle, senderBar, senderTitle);
    }

    @EventHandler
    public void onGroupMention(MentionGroupEvent e) {
        Player sender = e.getSender();
        String group = e.getGroup();
        Player[] targets = e.getTargets();
        LanguageManager LANGUAGE_MANAGER = DMentions.inst().getLanguageManager();
        ConfigurationSection configSection = DMentions.inst().getConfigGroupSection(group);
        ConfigurationSection languageSection = DMentions.inst().getLanguageGroupSection(group);
        if (configSection == null || languageSection == null) {
            return;
        }
        String soundName = configSection.getString("sound", "");
        String targetBar = LANGUAGE_MANAGER.getString(languageSection, "action_bar.target_message").replace("{p}", sender.getName()).replace("{group}", group);
        String targetTitle = LANGUAGE_MANAGER.getString(languageSection, "title.target_message").replace("{p}", sender.getName()).replace("{group}", group);
        String senderBar = LANGUAGE_MANAGER.getString(languageSection, "action_bar.sender_message").replace("{group}", group);
        String senderTitle = LANGUAGE_MANAGER.getString(languageSection, "title.sender_message").replace("{group}", group);
        this.mention(sender, targets, soundName, targetBar, targetTitle, senderBar, senderTitle);
    }

    private void mention(final Player sender, final Player[] targets, String soundName, final String targetBar, final String targetTitle, String senderBar, String senderTitle) {
        final DMentions plugin = DMentions.inst();
        final Sound sound = soundName != null && !soundName.isEmpty() ? plugin.getWrapper().getSound(soundName) : null;
        MessageManager.sendActionBar(sender, senderBar);
        MessageManager.sendTitle(sender, senderTitle);
        if (sound != null) {
            plugin.getWrapper().playSound(sender, sound);
        }
        new BukkitRunnable(){
            int counter = 0;
            final List<Player> targetList = Arrays.asList(targets);
            final boolean ignoreRespect = plugin.getConfiguration().getConfig().getBoolean("ignore_respect", true);
            final boolean afkRespect = plugin.getConfiguration().getConfig().getBoolean("afk_respect", false);
            final boolean vanishRespect = plugin.getConfiguration().getConfig().getBoolean("vanish_respect", true);

            public void run() {
                for (int i = 0; i < 30; ++i) {
                    boolean isVanished;
                    if (this.counter >= this.targetList.size()) {
                        this.cancel();
                        break;
                    }
                    Player target = this.targetList.get(this.counter++);
                    boolean isIgnored = this.ignoreRespect && EssentialsHook.isIgnored(sender, target);
                    boolean isAFK = this.afkRespect && EssentialsHook.isAFK(target);
                    boolean bl = isVanished = this.vanishRespect && EssentialsHook.isVanished(target);
                    if (target == null || target.equals((Object)sender) || plugin.isRestricted(sender, target) || isIgnored || isAFK || isVanished) continue;
                    if (sound != null) {
                        plugin.getWrapper().playSound(target, sound);
                    }
                    MessageManager.sendActionBar(target, targetBar);
                    MessageManager.sendTitle(target, targetTitle);
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 10L);
    }
}

