/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.object.DEnchantment;
import org.nandayo.dapi.object.DMaterial;
import org.nandayo.dmentions.MainCommand;
import org.nandayo.dmentions.bstats.bukkit.Metrics;
import org.nandayo.dmentions.enumeration.MentionType;
import org.nandayo.dmentions.event.PluginEvents;
import org.nandayo.dmentions.integration.EssentialsHook;
import org.nandayo.dmentions.integration.LP;
import org.nandayo.dmentions.integration.LPEvents;
import org.nandayo.dmentions.service.Config;
import org.nandayo.dmentions.service.CooldownManager;
import org.nandayo.dmentions.service.LanguageManager;
import org.nandayo.dmentions.service.MentionManager;
import org.nandayo.dmentions.service.MessageManager;
import org.nandayo.dmentions.service.PermissionManager;
import org.nandayo.dmentions.service.UpdateChecker;
import org.nandayo.dmentions.service.UserManager;
import org.nandayo.dmentions.service.Wrapper;

public final class DMentions
extends JavaPlugin
implements Listener {
    private static DMentions plugin;
    public final List<String> afterLoadPermissions = new ArrayList<String>();
    private Wrapper wrapper;
    private Config configuration;
    private MentionManager mentionManager;
    private UserManager userManager;
    private CooldownManager cooldownManager;
    private LanguageManager languageManager;
    private PermissionManager permissionManager = null;
    private Player guiConfigEditor = null;

    public static DMentions inst() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)this);
        pm.registerEvents((Listener)new PluginEvents(), (Plugin)this);
        Objects.requireNonNull(this.getCommand("dmentions")).setExecutor((CommandExecutor)new MainCommand());
        this.setupDAPI();
        this.setupIntegrations();
        this.updateVariables();
        if (this.configuration.getConfig().getBoolean("check_for_updates", true)) {
            new UpdateChecker((Plugin)this, 121452).getVersion(version -> {
                if (this.getDescription().getVersion().equals(version)) {
                    Util.log("&aPlugin is up-to-date.");
                } else {
                    Util.log("&fThere is a new version update. (&e" + version + "&f)");
                }
            });
        }
        new Metrics((Plugin)this, 24381);
    }

    public void onDisable() {
        this.userManager.saveChanges();
    }

    private void setupDAPI() {
        DAPI dapi = new DAPI((Plugin)plugin);
        dapi.registerMenuListener();
        Util.PREFIX = "&7[&eDMentions&7]&r ";
    }

    private void setupIntegrations() {
        if (Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
            new LP();
            new LPEvents(this, LP.getApi()).register();
            Util.log("&aLuckPerms integration has been enabled. Make sure you are using v5.1 or newer.");
        }
        if (Bukkit.getPluginManager().getPlugin("Essentials") != null) {
            new EssentialsHook();
            Bukkit.getPluginManager().registerEvents((Listener)new EssentialsHook.EssentialsListener(this), (Plugin)this);
            Util.log("&aEssentialX integration has been enabled. Make sure you are using v2.19.2 or newer.");
        }
    }

    public void updateVariables() {
        this.wrapper = new Wrapper(this);
        this.configuration = new Config(this).updateConfig();
        this.mentionManager = new MentionManager(this);
        if (this.userManager != null) {
            this.userManager.saveChanges();
        }
        this.userManager = new UserManager(this);
        this.cooldownManager = new CooldownManager(this);
        this.cooldownManager.updateConfigCooldowns();
        this.languageManager = new LanguageManager(this, this.configuration.getConfig().getString("lang_file", "en-US"));
        if (this.permissionManager == null) {
            this.permissionManager = new PermissionManager(this);
            this.permissionManager.clearAfterLoadPermissions();
            this.permissionManager.setupPermissions();
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.mentionManager.addPlayer(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.mentionManager.removePlayer(event.getPlayer());
        this.cooldownManager.removeCooldown(MentionType.PLAYER, event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChat(AsyncPlayerChatEvent e) {
        Player sender = e.getPlayer();
        String message = e.getMessage();
        if (e.isCancelled()) {
            return;
        }
        List disabledWorlds = this.configuration.getConfig().getStringList("disabled_worlds");
        if (disabledWorlds.contains(sender.getWorld().getName())) {
            MessageManager.sendSortedMessage(sender, this.languageManager.getString("disabled_world_warn"));
            return;
        }
        String mentionedString = this.mentionManager.getMentionedString(this, sender, message);
        e.setMessage(mentionedString);
    }

    public Material getMaterial(@NotNull DMaterial dMaterial, @NotNull DMaterial def) {
        Material mat = dMaterial.parseMaterial();
        if (mat != null) {
            return mat;
        }
        return def.parseMaterial();
    }

    public Enchantment getEnchantment(@NotNull DEnchantment dEnchantment, @NotNull DEnchantment def) {
        Enchantment mat = dEnchantment.get();
        if (mat != null) {
            return mat;
        }
        return def.get();
    }

    public boolean isRestricted(@NotNull Player sender, @NotNull Player target) {
        if (target.hasPermission("dmentions.mention.restricted")) {
            return !sender.hasPermission("dmentions.mention.restricted.bypass");
        }
        return false;
    }

    public ConfigurationSection getConfigGroupSection(@NotNull String groupName) {
        if (groupName.isEmpty()) {
            return null;
        }
        if (this.configuration.getConfig().getStringList("group.disabled_groups").contains(groupName)) {
            return null;
        }
        return this.configuration.getConfig().getConfigurationSection("group.list." + this.getGroupConfigTitle(groupName));
    }

    public ConfigurationSection getLanguageGroupSection(@NotNull String groupName) {
        return this.languageManager.getSection("group." + this.getGroupConfigTitle(groupName));
    }

    @NotNull
    public String getGroupConfigTitle(@Nullable String groupName) {
        if (groupName == null) {
            return "__OTHER__";
        }
        ConfigurationSection section = this.configuration.getConfig().getConfigurationSection("group.list");
        if (section == null || !section.contains(groupName)) {
            return "__OTHER__";
        }
        return groupName;
    }

    public String getPermission(String str) {
        return str == null || str.isEmpty() ? "" : str;
    }

    public String formattedTime(long millisecond) {
        long seconds = millisecond / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        seconds %= 60L;
        minutes %= 60L;
        hours %= 24L;
        if (days > 0L) {
            return String.format("%d d, %d h", days, hours);
        }
        if (hours > 0L) {
            return String.format("%d h, %d m", hours, minutes);
        }
        if (minutes > 0L) {
            return String.format("%d m, %d s", minutes, seconds);
        }
        return String.format("%d s", seconds);
    }

    public int parseInt(@NotNull String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Generated
    public List<String> getAfterLoadPermissions() {
        return this.afterLoadPermissions;
    }

    @Generated
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Generated
    public Config getConfiguration() {
        return this.configuration;
    }

    @Generated
    public MentionManager getMentionManager() {
        return this.mentionManager;
    }

    @Generated
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Generated
    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    @Generated
    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public Player getGuiConfigEditor() {
        return this.guiConfigEditor;
    }

    @Generated
    public void setGuiConfigEditor(Player guiConfigEditor) {
        this.guiConfigEditor = guiConfigEditor;
    }
}

