/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi.guimanager;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dapi.guimanager.AbstractButton;
import org.nandayo.dapi.guimanager.MenuType;
import org.nandayo.dapi.guimanager.SingleSlotButton;

public class Menu {
    @NotNull
    private final List<AbstractButton> abstractButtons = new ArrayList<AbstractButton>();
    @Deprecated(since="1.2", forRemoval=true)
    private int size;
    @NotNull
    private MenuType menuType = MenuType.CHEST_3_ROWS;
    @NotNull
    private String title = "Menu";
    @Nullable
    private Inventory inventory = null;
    @NotNull
    private Consumer<Inventory> closeCallback = inventory -> {};
    @NotNull
    private BiConsumer<PlayerInventory, Integer> onPlayerInventoryClick = (playerInventory, slot) -> {};
    private boolean emptySlotsModifiable = false;
    @NotNull
    private Function<Integer, SingleSlotButton> backgroundButtonFunction = slot -> null;

    public final boolean isButton(int slot) {
        return this.getButton(slot) != null;
    }

    @Nullable
    public final AbstractButton getButton(int slot) {
        return this.abstractButtons.stream().filter(b -> b.matchesSlot(slot)).findFirst().orElse(null);
    }

    @Nullable
    public final SingleSlotButton getBackgroundButton(int slot) {
        return this.backgroundButtonFunction.apply(slot);
    }

    protected final void createInventory(@NotNull MenuType menuType, @NotNull String title) {
        this.menuType = menuType;
        this.title = title;
        this.inventory = menuType.createInventory(title);
    }

    @Deprecated(since="1.2", forRemoval=true)
    protected final void createInventory(int size, @NotNull String title) {
        this.menuType = MenuType.CHEST_3_ROWS;
        this.title = title;
        this.inventory = Bukkit.createInventory(null, (int)size, (String)HexUtil.parse(title));
    }

    protected final void createInventory(@NotNull MenuType menuType) {
        this.createInventory(menuType, this.title);
    }

    @Deprecated(since="1.2", forRemoval=true)
    protected final void createInventory(int size) {
        this.createInventory(this.menuType, this.title);
    }

    protected final void createInventory() {
        this.createInventory(this.menuType, this.title);
    }

    @Deprecated(since="1.1.19", forRemoval=true)
    protected final void setSize(int size) {
        this.createInventory(this.menuType, this.title);
    }

    @Deprecated(since="1.1.19", forRemoval=true)
    protected final void setTitle(String title) {
        this.createInventory(this.menuType, title);
    }

    protected final <T extends AbstractButton> void addButton(@NotNull T button) {
        for (Integer slot : button.getSlots()) {
            this.removeButton(slot);
        }
        this.abstractButtons.add(button);
    }

    protected final void removeButton(@NotNull AbstractButton button) {
        this.abstractButtons.remove(button);
    }

    protected final void removeButton(int slot) {
        AbstractButton abstractButton = this.getButton(slot);
        if (abstractButton == null) {
            return;
        }
        abstractButton.removeSlot(slot);
    }

    @Nullable
    protected final ItemStack getInvItem(int slot) {
        if (this.inventory == null) {
            return null;
        }
        return this.inventory.getItem(slot);
    }

    protected final void setInvItem(int slot, @Nullable ItemStack item) {
        if (this.inventory == null) {
            return;
        }
        this.inventory.setItem(slot, item);
    }

    protected final void makeEmptySlotsModifiable(boolean b) {
        this.emptySlotsModifiable = b;
    }

    protected final void setBackgroundButton(Function<Integer, SingleSlotButton> function) {
        this.backgroundButtonFunction = function;
    }

    protected final void runOnClose(@NotNull Consumer<Inventory> callBack) {
        this.closeCallback = callBack;
    }

    protected final void runOnPlayerInventoryClick(@NotNull BiConsumer<PlayerInventory, Integer> callBack) {
        this.onPlayerInventoryClick = callBack;
    }

    protected final void displayTo(@NotNull Player p) {
        if (this.inventory == null) {
            this.createInventory(this.menuType, this.title);
        }
        Inventory inv = this.inventory;
        for (int i = 0; i < inv.getSize(); ++i) {
            SingleSlotButton singleSlotButton = this.getBackgroundButton(i);
            if (singleSlotButton == null || this.getButton(i) != null) continue;
            this.addButton(singleSlotButton);
        }
        for (AbstractButton abstractButton : this.getAbstractButtons()) {
            for (int slot : abstractButton.getSlots()) {
                inv.setItem(slot, abstractButton.getItem());
            }
        }
        p.openInventory(inv);
        DAPI dapi = DAPI.getInstance();
        p.setMetadata(dapi.GUI_METADATA_KEY, (MetadataValue)new FixedMetadataValue(dapi.plugin, (Object)this));
    }

    @NotNull
    @Generated
    protected List<AbstractButton> getAbstractButtons() {
        return this.abstractButtons;
    }

    @Deprecated
    @Generated
    protected int getSize() {
        return this.size;
    }

    @NotNull
    @Generated
    protected MenuType getMenuType() {
        return this.menuType;
    }

    @NotNull
    @Generated
    protected String getTitle() {
        return this.title;
    }

    @Nullable
    @Generated
    protected Inventory getInventory() {
        return this.inventory;
    }

    @NotNull
    @Generated
    protected Consumer<Inventory> getCloseCallback() {
        return this.closeCallback;
    }

    @NotNull
    @Generated
    protected BiConsumer<PlayerInventory, Integer> getOnPlayerInventoryClick() {
        return this.onPlayerInventoryClick;
    }

    @Generated
    protected boolean isEmptySlotsModifiable() {
        return this.emptySlotsModifiable;
    }

    @NotNull
    @Generated
    protected Function<Integer, SingleSlotButton> getBackgroundButtonFunction() {
        return this.backgroundButtonFunction;
    }
}

