/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.LP;
import org.nandayo.dmentions.service.ConfigManager;

public class PermissionManager {
    private final DMentions plugin;
    private final ConfigManager configManager;

    public PermissionManager(DMentions plugin) {
        this.plugin = plugin;
        this.configManager = plugin.CONFIG_MANAGER;
    }

    public void setupPermissions() {
        String playerPermission = this.plugin.getPermission(this.configManager.getString("player.permission", "dmentions.mention.player"));
        String everyonePermission = this.plugin.getPermission(this.configManager.getString("everyone.permission", "dmentions.mention.everyone"));
        String nearbyPermission = this.plugin.getPermission(this.configManager.getString("nearby.permission", "dmentions.mention.nearby"));
        Bukkit.getPluginManager().addPermission(new Permission(playerPermission, PermissionDefault.OP));
        Bukkit.getPluginManager().addPermission(new Permission(nearbyPermission, PermissionDefault.OP));
        Bukkit.getPluginManager().addPermission(new Permission(everyonePermission, PermissionDefault.OP));
        this.plugin.afterLoadPermissions.add(playerPermission);
        this.plugin.afterLoadPermissions.add(nearbyPermission);
        this.plugin.afterLoadPermissions.add(everyonePermission);
        if (LP.isConnected()) {
            Permission adminPermission = Bukkit.getPluginManager().getPermission("dmentions.admin");
            if (adminPermission == null) {
                return;
            }
            HashMap<String, Boolean> children = new HashMap<String, Boolean>();
            children.put(playerPermission, true);
            children.put(everyonePermission, true);
            for (String group : LP.getGroups()) {
                String groupPermission = this.plugin.getPermission(this.configManager.getString("group.permission", "")).replace("{group}", group);
                Bukkit.getPluginManager().addPermission(new Permission(groupPermission, PermissionDefault.OP));
                this.plugin.afterLoadPermissions.add(groupPermission);
                children.put(groupPermission, true);
            }
            adminPermission.getChildren().putAll(children);
            adminPermission.recalculatePermissibles();
        }
    }

    public void clearAfterLoadPermissions() {
        if (this.plugin.afterLoadPermissions.isEmpty()) {
            return;
        }
        Permission adminPermission = Bukkit.getPluginManager().getPermission("dmentions.admin");
        for (String perm : this.plugin.afterLoadPermissions) {
            Permission permission = Bukkit.getPluginManager().getPermission(perm);
            if (permission != null) {
                Bukkit.getPluginManager().removePermission(permission);
            }
            if (adminPermission == null || !adminPermission.getChildren().containsKey(perm)) continue;
            adminPermission.getChildren().remove(perm);
            adminPermission.recalculatePermissibles();
        }
        this.plugin.afterLoadPermissions.clear();
    }
}

