/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dmentions.service.ConfigManager;

public class MessageManager {
    private final ConfigManager configManager;

    public MessageManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void sendSortedMessage(Player player, String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        String[] parts = msg.split("=");
        if (parts.length < 2) {
            this.sendMessage(player, msg);
        }
        switch (parts[0]) {
            case "CHAT": {
                this.sendMessage(player, parts[1]);
                break;
            }
            case "ACTION_BAR": {
                this.sendActionBar(player, parts[1]);
                break;
            }
            case "TITLE": {
                this.sendTitle(player, parts[1]);
            }
        }
    }

    public void sendMessage(Player player, String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        String formattedText = HexUtil.color(this.prefixedString(msg));
        player.sendMessage(formattedText);
    }

    public void sendActionBar(Player player, String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        String formattedText = HexUtil.color(this.prefixedString(msg));
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)formattedText));
    }

    public void sendTitle(Player player, String msg) {
        if (msg == null || msg.isEmpty()) {
            return;
        }
        String[] lines = msg.split("\\|\\|");
        String title = HexUtil.color(this.prefixedString(lines[0]));
        String subtitle = lines.length > 1 ? HexUtil.color(this.prefixedString(lines[1])) : "";
        player.sendTitle(title, subtitle, 10, 30, 20);
    }

    public String prefixedString(String str) {
        if (str == null || str.isEmpty()) {
            return "";
        }
        String prefix = this.configManager.getString("prefix", "");
        return str.replaceAll("\\{PREFIX}", prefix);
    }
}

