/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.Util;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.service.ConfigManager;

public class LanguageManager {
    private final DMentions plugin;
    private final File folder;
    public final List<String> REGISTERED_LANGUAGES = new ArrayList<String>();
    private final List<String> DEFAULT_LANGUAGES = Arrays.asList("en-US", "tr-TR", "zh-CN");
    private final String DEFAULT_LANGUAGE = "en-US";
    private FileConfiguration DEFAULT_LANGUAGE_CONFIG;
    private FileConfiguration SELECTED_LANGUAGE_CONFIG;

    public LanguageManager(@NotNull DMentions plugin, @NotNull File folder, @NotNull String fileName) {
        this.plugin = plugin;
        this.folder = folder;
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.loadDefaultFiles();
        this.loadFiles(fileName);
    }

    private void loadFiles(@NotNull String searchingFor) {
        File[] files = this.folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName().substring(0, file.getName().length() - 4);
                this.REGISTERED_LANGUAGES.add(fileName);
                if (fileName.equals(searchingFor)) {
                    Object object = this.SELECTED_LANGUAGE_CONFIG = this.DEFAULT_LANGUAGES.contains(fileName) ? this.updateLanguage(fileName) : YamlConfiguration.loadConfiguration((File)file);
                }
                if (!fileName.equals("en-US")) continue;
                this.DEFAULT_LANGUAGE_CONFIG = this.updateLanguage(fileName);
            }
        }
        if (this.SELECTED_LANGUAGE_CONFIG == null) {
            this.SELECTED_LANGUAGE_CONFIG = this.DEFAULT_LANGUAGE_CONFIG;
            Util.log("&cLanguage " + searchingFor + " was not found. Using default language.");
        }
    }

    private void loadDefaultFiles() {
        for (String fileName : this.DEFAULT_LANGUAGES) {
            File file = new File(this.folder, fileName + ".yml");
            if (file.exists() || this.plugin.getResource("lang/" + fileName + ".yml") == null) continue;
            this.plugin.saveResource("lang/" + fileName + ".yml", false);
        }
    }

    public FileConfiguration updateLanguage(@NotNull String languageName) {
        String configVersion;
        File file = new File(this.folder, languageName + ".yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String version = this.plugin.getDescription().getVersion();
        if (version.equals(configVersion = config.getString("lang_version", "0"))) {
            return config;
        }
        InputStream defStream = this.plugin.getResource("lang/" + languageName + ".yml");
        if (defStream == null) {
            Util.log("&cDefault '" + languageName + ".yml' was not found in plugin resources.");
            return config;
        }
        this.saveBackupConfig(languageName, (FileConfiguration)config);
        YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream));
        for (String key : defConfig.getKeys(true)) {
            if (defConfig.isConfigurationSection(key) || !config.contains(key)) continue;
            defConfig.set(key, config.get(key));
        }
        try {
            defConfig.set("lang_version", (Object)version);
            defConfig.save(new File(this.folder, languageName + ".yml"));
            config = defConfig;
            Util.log("&aUpdated language file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save updated language file. " + e.getMessage());
        }
        return config;
    }

    private void saveBackupConfig(@NotNull String languageName, @NotNull FileConfiguration config) {
        File backupDir = new File(this.plugin.getDataFolder(), "backups");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        String date = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        File backupFile = new File(backupDir, "lang_" + languageName + "_" + date + ".yml");
        try {
            config.save(backupFile);
            Util.log("&aBacked up old language file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save old language backup file. " + e.getMessage());
        }
    }

    @Nullable
    public ConfigurationSection getSection(@NotNull String path) {
        ConfigurationSection section = this.SELECTED_LANGUAGE_CONFIG.getConfigurationSection(path);
        if (section != null) {
            return section;
        }
        return this.DEFAULT_LANGUAGE_CONFIG.getConfigurationSection(path);
    }

    @NotNull
    public Object getMessage(@NotNull String path) {
        return this.SELECTED_LANGUAGE_CONFIG.contains(path) ? this.SELECTED_LANGUAGE_CONFIG.get(path, (Object)"") : this.DEFAULT_LANGUAGE_CONFIG.get(path, (Object)"");
    }

    @NotNull
    public Object getMessage(@Nullable ConfigurationSection section, @NotNull String subPath) {
        String currentPath = section == null ? "" : section.getCurrentPath();
        return this.getMessage(currentPath + "." + subPath);
    }

    @NotNull
    public Replacer getMessageReplaceable(@NotNull String path) {
        Object message = this.getMessage(path);
        if (message instanceof String) {
            return new Replacer((String)message);
        }
        if (message instanceof String[]) {
            return new Replacer((String[])message);
        }
        if (message instanceof List) {
            return new Replacer(((List)message).toArray(new String[0]));
        }
        return new Replacer("");
    }

    @NotNull
    public Replacer getMessageReplaceable(@Nullable ConfigurationSection section, @NotNull String subPath) {
        String currentPath = section == null ? "" : section.getCurrentPath();
        return this.getMessageReplaceable(currentPath + "." + subPath);
    }

    public String[] getValueDisplayMessage(@NotNull String langPath, @NotNull String configPath, @NotNull ConfigManager configManager) {
        return this.getMessageReplaceable(langPath).replace("{value}", configManager.get(configPath, "")).replace("{unsaved_value}", configManager.get(configPath, "", true)).get();
    }

    public String[] getValueDisplayMessage(@Nullable ConfigurationSection section, @NotNull String langSubPath, @NotNull String configPath, @NotNull ConfigManager configManager) {
        return this.getMessageReplaceable(section, langSubPath).replace("{value}", configManager.get(configPath, "")).replace("{unsaved_value}", configManager.get(configPath, "", true)).get();
    }

    public static class Replacer {
        private String[] str;

        public Replacer(String ... str) {
            this.str = str;
        }

        public Replacer replace(@NotNull String replacement, @NotNull Object value) {
            String[] replaced = new String[this.str.length];
            for (int index = 0; index < this.str.length; ++index) {
                replaced[index] = this.str[index].replace(replacement, value.toString());
            }
            this.str = replaced;
            return this;
        }

        public String[] get() {
            return this.str;
        }
    }
}

