/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dapi.Util;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.service.ConfigManager;

public class GUIManager {
    private final DMentions plugin;
    private final ConfigManager configManager;
    private final Player player;

    public GUIManager(DMentions plugin, ConfigManager configManager, Player modifier) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.player = modifier;
    }

    public Object getUValue(String key, Object def) {
        return this.configManager.get(key, def, true);
    }

    public void setUValue(String key, Object value) {
        this.configManager.set(key, value, true);
    }

    public ConfigurationSection getUSection(String key) {
        return this.configManager.getConfigurationSection(key, true);
    }

    public List<String> getUStringList(String key) {
        return this.configManager.getStringList(key, true);
    }

    public boolean contains(String key) {
        return this.configManager.get(key, null, true) != null;
    }

    public boolean isValueChanged(@NotNull String key) {
        return !Objects.equals(this.configManager.get(key, ""), this.configManager.get(key, "", true));
    }

    public void resetChanges() {
        this.configManager.resetGuiConfig();
        this.player.sendMessage(HexUtil.color((String)this.plugin.LANGUAGE_MANAGER.getMessage("command.config.reset_changes")));
    }

    public void saveChanges() {
        this.configManager.saveGuiConfig();
        this.player.sendMessage(HexUtil.color((String)this.plugin.LANGUAGE_MANAGER.getMessage("command.config.save_changes")));
        Util.log("&eUpdated config keys in-game by player " + this.player.getName() + ".");
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }
}

