/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.util.HashMap;
import java.util.Locale;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.mention.MentionType;
import org.nandayo.dmentions.service.Cooldown;
import org.nandayo.dmentions.service.LanguageManager;
import org.nandayo.dmentions.service.MessageManager;

public class CooldownManager {
    private final DMentions plugin;
    private final HashMap<MentionType, Cooldown<String>> COOLDOWN_MAP_MS = new HashMap();
    private final HashMap<String, Long> CONFIG_COOLDOWN_MS = new HashMap();

    public CooldownManager(DMentions plugin) {
        this.plugin = plugin;
    }

    public void updateLastUse(@NotNull MentionType mentionType, @Nullable String name) {
        this.COOLDOWN_MAP_MS.computeIfAbsent(mentionType, k -> new Cooldown()).update(name);
    }

    public long getRemaining(@NotNull MentionType mentionType, @Nullable String name) {
        return this.COOLDOWN_MAP_MS.computeIfAbsent(mentionType, k -> new Cooldown()).getRemaining(name, this.getConfigCooldown(mentionType, name));
    }

    public void removeCooldown(@NotNull MentionType mentionType, @Nullable String name) {
        Cooldown<String> cooldown = this.COOLDOWN_MAP_MS.get((Object)mentionType);
        if (cooldown != null) {
            cooldown.remove(name);
        }
    }

    public void updateConfigCooldowns() {
        this.CONFIG_COOLDOWN_MS.clear();
        this.CONFIG_COOLDOWN_MS.put("player", this.plugin.CONFIG_MANAGER.getLong("player.cooldown", 0L) * 1000L);
        this.CONFIG_COOLDOWN_MS.put("nearby", this.plugin.CONFIG_MANAGER.getLong("nearby.cooldown", 0L) * 1000L);
        this.CONFIG_COOLDOWN_MS.put("everyone", this.plugin.CONFIG_MANAGER.getLong("everyone.cooldown", 0L) * 1000L);
        ConfigurationSection groupSection = this.plugin.CONFIG_MANAGER.getConfigurationSection("group.list");
        if (groupSection == null) {
            return;
        }
        for (String group : groupSection.getKeys(false)) {
            if (this.plugin.CONFIG_MANAGER.getStringList("group.disabled_groups").contains(group)) continue;
            this.CONFIG_COOLDOWN_MS.put("group_" + group, groupSection.getLong(group + ".cooldown", 0L) * 1000L);
        }
    }

    private long getConfigCooldown(@NotNull MentionType mentionType, @Nullable String name) {
        switch (mentionType) {
            case PLAYER: 
            case NEARBY: 
            case EVERYONE: {
                return this.CONFIG_COOLDOWN_MS.getOrDefault(mentionType.name().toLowerCase(Locale.ENGLISH), 0L);
            }
            case GROUP: {
                return this.CONFIG_COOLDOWN_MS.get("group_" + this.plugin.getGroupConfigTitle(name));
            }
        }
        return 0L;
    }

    public void cooldownWarn(@NotNull Player sender, long remaining) {
        if (remaining <= 0L) {
            return;
        }
        LanguageManager LANGUAGE_MANAGER = this.plugin.LANGUAGE_MANAGER;
        String msg = LANGUAGE_MANAGER.getMessageReplaceable("cooldown_warn").replace("{REMAINED}", this.plugin.formattedTime(remaining)).get()[0];
        new MessageManager(this.plugin.CONFIG_MANAGER).sendSortedMessage(sender, msg);
    }
}

