/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.service;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.nandayo.dapi.Util;
import org.nandayo.dmentions.DMentions;

public class ConfigManager {
    private YamlConfiguration config;
    private YamlConfiguration uConfig;

    public ConfigManager(FileConfiguration config) {
        this.config = YamlConfiguration.loadConfiguration((Reader)new StringReader(config.saveToString()));
        this.uConfig = YamlConfiguration.loadConfiguration((Reader)new StringReader(config.saveToString()));
    }

    public void set(String key, Object value, boolean isGuiConfig) {
        if (isGuiConfig) {
            this.uConfig.set(key, value);
        } else {
            this.config.set(key, value);
        }
    }

    public Object get(String key, Object defaultValue, boolean isGuiConfig) {
        return isGuiConfig ? this.uConfig.get(key, defaultValue) : this.config.get(key, defaultValue);
    }

    public Object get(String key, Object defaultValue) {
        return this.get(key, defaultValue, false);
    }

    public String getString(String key, String defaultValue, boolean isGuiConfig) {
        return isGuiConfig ? this.uConfig.getString(key, defaultValue) : this.config.getString(key, defaultValue);
    }

    public String getString(String key, String defaultValue) {
        return this.getString(key, defaultValue, false);
    }

    public int getInt(String key, int defaultValue, boolean isGuiConfig) {
        return isGuiConfig ? this.uConfig.getInt(key, defaultValue) : this.config.getInt(key, defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        return this.getInt(key, defaultValue, false);
    }

    public long getLong(String key, long defaultValue, boolean isGuiConfig) {
        return isGuiConfig ? this.uConfig.getLong(key, defaultValue) : this.config.getLong(key, defaultValue);
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(key, defaultValue, false);
    }

    public boolean getBoolean(String key, boolean defaultValue, boolean isGuiConfig) {
        return isGuiConfig ? this.uConfig.getBoolean(key, defaultValue) : this.config.getBoolean(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, defaultValue, false);
    }

    public ConfigurationSection getConfigurationSection(String key, boolean isGuiConfig) {
        return isGuiConfig ? this.uConfig.getConfigurationSection(key) : this.config.getConfigurationSection(key);
    }

    public ConfigurationSection getConfigurationSection(String key) {
        return this.getConfigurationSection(key, false);
    }

    public List<String> getStringList(String key, boolean isGuiConfig) {
        return isGuiConfig ? this.uConfig.getStringList(key) : this.config.getStringList(key);
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, false);
    }

    public void saveGuiConfig() {
        try {
            this.config = this.uConfig;
            this.config.save(new File(DMentions.inst().getDataFolder(), "config.yml"));
            DMentions.inst().updateVariables();
        }
        catch (IOException e) {
            Util.log("Could not save GUI Config. " + e.getMessage());
        }
    }

    public void resetGuiConfig() {
        this.uConfig = YamlConfiguration.loadConfiguration((Reader)new StringReader(this.config.saveToString()));
    }

    @Generated
    public YamlConfiguration getConfig() {
        return this.config;
    }
}

