/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.LP;
import org.nandayo.dmentions.menu.AnvilManager;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;
import org.nandayo.dmentions.service.ConfigManager;
import org.nandayo.dmentions.service.GUIManager;
import org.nandayo.dmentions.service.LanguageManager;

public class SubSuffixMenu
extends Menu {
    private final DMentions plugin;
    private final Player player;
    private final GUIManager manager;
    private final ConfigManager configManager;

    public SubSuffixMenu(DMentions plugin, Player player, GUIManager manager) {
        this.plugin = plugin;
        this.configManager = plugin.CONFIG_MANAGER;
        this.player = player;
        this.manager = manager;
        this.open();
    }

    public void open() {
        final LanguageManager LANGUAGE_MANAGER = this.plugin.LANGUAGE_MANAGER;
        final ConfigurationSection menuSection = LANGUAGE_MANAGER.getSection("menu.suffix_menu");
        this.createInventory(54, (String)LANGUAGE_MANAGER.getMessage(menuSection, "title"));
        int i = 0;
        ConfigurationSection section = this.manager.getUSection("suffix_color.group");
        for (final String suffixGroup : section.getKeys(false)) {
            this.addButton(new Button(i++){
                final String configPath;
                final String changed;
                final String langPathName = "existent_group";
                {
                    super(slot);
                    this.configPath = "suffix_color.group." + suffixGroup;
                    this.changed = SubSuffixMenu.this.manager.isValueChanged(this.configPath) ? "changed" : "unchanged";
                    this.langPathName = "existent_group";
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.GREEN_BANNER).name(LANGUAGE_MANAGER.getMessageReplaceable(menuSection, "existent_group.display_name").replace("{group}", suffixGroup).get()[0]).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "existent_group.lore." + this.changed, this.configPath, SubSuffixMenu.this.configManager)).get();
                }

                @Override
                public void onClick(Player p, ClickType clickType) {
                    if (clickType == ClickType.LEFT) {
                        new AnvilManager(SubSuffixMenu.this.plugin, SubSuffixMenu.this.manager, SubSuffixMenu.this.player, this.configPath, (String)LANGUAGE_MANAGER.getMessage(menuSection, "existent_group.edit_title"), text -> {
                            SubSuffixMenu.this.manager.setUValue(this.configPath, text);
                            new SubSuffixMenu(SubSuffixMenu.this.plugin, SubSuffixMenu.this.player, SubSuffixMenu.this.manager);
                        });
                    } else if (clickType == ClickType.RIGHT) {
                        SubSuffixMenu.this.manager.setUValue(this.configPath, null);
                        new SubSuffixMenu(SubSuffixMenu.this.plugin, SubSuffixMenu.this.player, SubSuffixMenu.this.manager);
                    }
                }
            });
        }
        i = i - i % 9 + 9;
        if (LP.isConnected()) {
            for (final String group : LP.getGroups()) {
                if (section.contains(group)) continue;
                this.addButton(new Button(i++){
                    final String langPathName = "nonexistent_group";
                    {
                        super(slot);
                        this.langPathName = "nonexistent_group";
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.BLACK_BANNER).name(LANGUAGE_MANAGER.getMessageReplaceable(menuSection, "nonexistent_group.display_name").replace("{group}", group).get()[0]).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "nonexistent_group.lore")).get();
                    }

                    @Override
                    public void onClick(Player p, ClickType clickType) {
                        SubSuffixMenu.this.manager.setUValue("suffix_color.group." + group, "&f");
                        new SubSuffixMenu(SubSuffixMenu.this.plugin, SubSuffixMenu.this.player, SubSuffixMenu.this.manager);
                    }
                });
            }
        }
        this.addButton(new Button(45){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name((String)LANGUAGE_MANAGER.getMessage("menu.back.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.back.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new GeneralSettingsMenu(SubSuffixMenu.this.plugin, SubSuffixMenu.this.player, SubSuffixMenu.this.manager);
            }
        });
        this.runOnClose(inv -> {
            this.plugin.GUI_CONFIG_EDITOR = null;
        });
        this.displayTo(this.player);
        this.plugin.GUI_CONFIG_EDITOR = this.player;
    }
}

