/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.LP;
import org.nandayo.dmentions.mention.MentionType;
import org.nandayo.dmentions.menu.MentionSettingsMenu;
import org.nandayo.dmentions.menu.MentionTypeSettingsMenu;
import org.nandayo.dmentions.service.GUIManager;
import org.nandayo.dmentions.service.LanguageManager;

public class SubMentionAddGroupMenu
extends Menu {
    private final DMentions plugin;
    private final Player player;
    private final GUIManager manager;

    public SubMentionAddGroupMenu(DMentions plugin, Player player, GUIManager manager) {
        this.plugin = plugin;
        this.player = player;
        this.manager = manager;
        this.open();
    }

    public void open() {
        final LanguageManager LANGUAGE_MANAGER = this.plugin.LANGUAGE_MANAGER;
        final ConfigurationSection menuSection = LANGUAGE_MANAGER.getSection("menu.add_group_menu");
        this.createInventory(54, (String)LANGUAGE_MANAGER.getMessage(menuSection, "title"));
        ConfigurationSection section = this.manager.getUSection("group.list");
        List<String> disabledGroups = this.manager.getUStringList("group.disabled_groups");
        if (LP.isConnected()) {
            int i = 0;
            for (final String group : LP.getGroups()) {
                if (section.contains(group) || disabledGroups.contains(group)) continue;
                this.addButton(new Button(i++){
                    final String langPathName = "not_added_group";
                    {
                        super(slot);
                        this.langPathName = "not_added_group";
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.YELLOW_BANNER).name(LANGUAGE_MANAGER.getMessageReplaceable(menuSection, "not_added_group.display_name").replace("{group}", group).get()[0]).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "not_added_group.lore")).get();
                    }

                    @Override
                    public void onClick(Player p, ClickType clickType) {
                        SubMentionAddGroupMenu.this.manager.setUValue("group.list." + group + ".sound", "BLOCK_NOTE_BLOCK_PLING");
                        SubMentionAddGroupMenu.this.manager.setUValue("group.list." + group + ".display", "<#73c7dc>@{group}");
                        SubMentionAddGroupMenu.this.manager.setUValue("group.list." + group + ".cooldown", 5);
                        new MentionTypeSettingsMenu(SubMentionAddGroupMenu.this.plugin, SubMentionAddGroupMenu.this.player, SubMentionAddGroupMenu.this.manager, MentionType.GROUP, group);
                    }
                });
            }
        }
        this.addButton(new Button(45){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name((String)LANGUAGE_MANAGER.getMessage("menu.back.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.back.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new MentionSettingsMenu(SubMentionAddGroupMenu.this.plugin, SubMentionAddGroupMenu.this.player, SubMentionAddGroupMenu.this.manager);
            }
        });
        this.runOnClose(inv -> {
            this.plugin.GUI_CONFIG_EDITOR = null;
        });
        this.displayTo(this.player);
        this.plugin.GUI_CONFIG_EDITOR = this.player;
    }
}

