/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;
import org.nandayo.dmentions.service.GUIManager;
import org.nandayo.dmentions.service.LanguageManager;

public class SubLanguageMenu
extends Menu {
    private final DMentions plugin;
    private final Player player;
    private final GUIManager manager;

    public SubLanguageMenu(DMentions plugin, Player player, GUIManager manager) {
        this.plugin = plugin;
        this.player = player;
        this.manager = manager;
        this.open();
    }

    public void open() {
        final LanguageManager LANGUAGE_MANAGER = this.plugin.LANGUAGE_MANAGER;
        final ConfigurationSection menuSection = LANGUAGE_MANAGER.getSection("menu.language_menu");
        this.createInventory(54, (String)LANGUAGE_MANAGER.getMessage(menuSection, "title"));
        int i = 0;
        for (final String lang : this.plugin.LANGUAGE_MANAGER.REGISTERED_LANGUAGES) {
            this.addButton(new Button(i++){
                final String langPathName = "language";
                {
                    super(slot);
                    this.langPathName = "language";
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.BOOK).name(LANGUAGE_MANAGER.getMessageReplaceable(menuSection, "language.display_name").replace("{language}", lang).get()[0]).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "language.lore")).get();
                }

                @Override
                public void onClick(Player p, ClickType clickType) {
                    SubLanguageMenu.this.manager.setUValue("lang_file", lang);
                    new GeneralSettingsMenu(SubLanguageMenu.this.plugin, SubLanguageMenu.this.player, SubLanguageMenu.this.manager);
                }
            });
        }
        this.addButton(new Button(45){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name((String)LANGUAGE_MANAGER.getMessage("menu.back.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.back.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new GeneralSettingsMenu(SubLanguageMenu.this.plugin, SubLanguageMenu.this.player, SubLanguageMenu.this.manager);
            }
        });
        this.runOnClose(inv -> {
            this.plugin.GUI_CONFIG_EDITOR = null;
        });
        this.displayTo(this.player);
        this.plugin.GUI_CONFIG_EDITOR = this.player;
    }
}

