/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;
import org.nandayo.dmentions.service.GUIManager;
import org.nandayo.dmentions.service.LanguageManager;

public class SubDisabledWorldsMenu
extends Menu {
    private final DMentions plugin;
    private final Player player;
    private final GUIManager manager;

    public SubDisabledWorldsMenu(DMentions plugin, Player player, GUIManager manager) {
        this.plugin = plugin;
        this.player = player;
        this.manager = manager;
        this.open();
    }

    public void open() {
        final LanguageManager LANGUAGE_MANAGER = this.plugin.LANGUAGE_MANAGER;
        final ConfigurationSection menuSection = LANGUAGE_MANAGER.getSection("menu.disabled_worlds_menu");
        this.createInventory(54, (String)LANGUAGE_MANAGER.getMessage(menuSection, "title"));
        int i = 0;
        final List<String> disabledList = this.manager.getUStringList("disabled_worlds");
        for (final String world : disabledList) {
            this.addButton(new Button(i++){
                final String langPathName = "disabled_world";
                {
                    super(slot);
                    this.langPathName = "disabled_world";
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.RED_BANNER).name(LANGUAGE_MANAGER.getMessageReplaceable(menuSection, "disabled_world.display_name").replace("{world}", world).get()[0]).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "disabled_world.lore")).get();
                }

                @Override
                public void onClick(Player p, ClickType clickType) {
                    disabledList.remove(world);
                    SubDisabledWorldsMenu.this.manager.setUValue("disabled_worlds", disabledList);
                    new SubDisabledWorldsMenu(SubDisabledWorldsMenu.this.plugin, SubDisabledWorldsMenu.this.player, SubDisabledWorldsMenu.this.manager);
                }
            });
        }
        i = i - i % 9 + 9;
        for (World w : Bukkit.getWorlds()) {
            final String world = w.getName();
            if (disabledList.contains(world)) continue;
            this.addButton(new Button(i++){
                final String langPathName = "non-disabled_world";
                {
                    super(slot);
                    this.langPathName = "non-disabled_world";
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.GREEN_BANNER).name(LANGUAGE_MANAGER.getMessageReplaceable(menuSection, "non-disabled_world.display_name").replace("{world}", world).get()[0]).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "non-disabled_world.lore")).get();
                }

                @Override
                public void onClick(Player p, ClickType clickType) {
                    disabledList.add(world);
                    SubDisabledWorldsMenu.this.manager.setUValue("disabled_worlds", disabledList);
                    new SubDisabledWorldsMenu(SubDisabledWorldsMenu.this.plugin, SubDisabledWorldsMenu.this.player, SubDisabledWorldsMenu.this.manager);
                }
            });
        }
        this.addButton(new Button(45){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name((String)LANGUAGE_MANAGER.getMessage("menu.back.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.back.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new GeneralSettingsMenu(SubDisabledWorldsMenu.this.plugin, SubDisabledWorldsMenu.this.player, SubDisabledWorldsMenu.this.manager);
            }
        });
        this.runOnClose(inv -> {
            this.plugin.GUI_CONFIG_EDITOR = null;
        });
        this.displayTo(this.player);
        this.plugin.GUI_CONFIG_EDITOR = this.player;
    }
}

