/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.LP;
import org.nandayo.dmentions.menu.MentionSettingsMenu;
import org.nandayo.dmentions.service.GUIManager;
import org.nandayo.dmentions.service.LanguageManager;

public class SubDisabledGroupsMenu
extends Menu {
    private final DMentions plugin;
    private final Player player;
    private final GUIManager manager;

    public SubDisabledGroupsMenu(DMentions plugin, Player player, GUIManager manager) {
        this.plugin = plugin;
        this.player = player;
        this.manager = manager;
        this.open();
    }

    public void open() {
        final LanguageManager LANGUAGE_MANAGER = this.plugin.LANGUAGE_MANAGER;
        final ConfigurationSection menuSection = LANGUAGE_MANAGER.getSection("menu.disabled_groups_menu");
        this.createInventory(54, (String)LANGUAGE_MANAGER.getMessage(menuSection, "title"));
        int i = 0;
        final List<String> disabledList = this.manager.getUStringList("group.disabled_groups");
        for (final String group : disabledList) {
            this.addButton(new Button(i++){

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.RED_BANNER).name(LANGUAGE_MANAGER.getMessageReplaceable(menuSection, "disabled_group.display_name").replace("{group}", group).get()[0]).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "disabled_group.lore")).get();
                }

                @Override
                public void onClick(Player p, ClickType clickType) {
                    disabledList.remove(group);
                    SubDisabledGroupsMenu.this.manager.setUValue("group.disabled_groups", disabledList);
                    new SubDisabledGroupsMenu(SubDisabledGroupsMenu.this.plugin, SubDisabledGroupsMenu.this.player, SubDisabledGroupsMenu.this.manager);
                }
            });
        }
        i = i - i % 9 + 9;
        if (LP.isConnected()) {
            for (final String group : LP.getGroups()) {
                if (disabledList.contains(group)) continue;
                this.addButton(new Button(i++){
                    final String langPathName = "non-disabled_group";
                    {
                        super(slot);
                        this.langPathName = "non-disabled_group";
                    }

                    @Override
                    public ItemStack getItem() {
                        return ItemCreator.of(Material.GREEN_BANNER).name(LANGUAGE_MANAGER.getMessageReplaceable(menuSection, "non-disabled_group.display_name").replace("{group}", group).get()[0]).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "non-disabled_group.lore")).get();
                    }

                    @Override
                    public void onClick(Player p, ClickType clickType) {
                        disabledList.add(group);
                        SubDisabledGroupsMenu.this.manager.setUValue("group.disabled_groups", disabledList);
                        new SubDisabledGroupsMenu(SubDisabledGroupsMenu.this.plugin, SubDisabledGroupsMenu.this.player, SubDisabledGroupsMenu.this.manager);
                    }
                });
            }
        }
        this.addButton(new Button(45){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ARROW).name((String)LANGUAGE_MANAGER.getMessage("menu.back.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.back.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new MentionSettingsMenu(SubDisabledGroupsMenu.this.plugin, SubDisabledGroupsMenu.this.player, SubDisabledGroupsMenu.this.manager);
            }
        });
        this.runOnClose(inv -> {
            this.plugin.GUI_CONFIG_EDITOR = null;
        });
        this.displayTo(this.player);
        this.plugin.GUI_CONFIG_EDITOR = this.player;
    }
}

