/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.LazyButton;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.dapi.object.DEnchantment;
import org.nandayo.dapi.object.DMaterial;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.mention.MentionType;
import org.nandayo.dmentions.menu.AnvilManager;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;
import org.nandayo.dmentions.menu.MentionSettingsMenu;
import org.nandayo.dmentions.menu.SubDisabledGroupsMenu;
import org.nandayo.dmentions.menu.SubMentionAddGroupMenu;
import org.nandayo.dmentions.service.ConfigManager;
import org.nandayo.dmentions.service.GUIManager;
import org.nandayo.dmentions.service.LanguageManager;

public class MentionTypeSettingsMenu
extends Menu {
    private final List<String> insiderVar = Arrays.asList("sound", "display", "cooldown");
    private final DMentions plugin;
    private final Player player;
    private final GUIManager manager;
    private final ConfigManager configManager;
    private final MentionType mentionType;
    private final String group;

    public MentionTypeSettingsMenu(DMentions plugin, Player player, GUIManager manager, MentionType mentionType, String group) {
        this.plugin = plugin;
        this.configManager = plugin.CONFIG_MANAGER;
        this.player = player;
        this.manager = manager;
        this.mentionType = mentionType;
        this.group = group;
        this.open();
    }

    public void open() {
        final LanguageManager LANGUAGE_MANAGER = this.plugin.LANGUAGE_MANAGER;
        final ConfigurationSection menuSection = LANGUAGE_MANAGER.getSection("menu.mention_type_settings_menu");
        final String langMentionKey = this.mentionType == MentionType.GROUP ? "group" : "other";
        this.createInventory(54, LANGUAGE_MANAGER.getMessageReplaceable(menuSection, "title." + langMentionKey).replace("{mentionType}", this.mentionType.toString().toUpperCase(Locale.ENGLISH)).replace("{group}", this.group == null ? "?" : this.group).get()[0]);
        this.addLazyButton(new LazyButton(Arrays.asList(1, 10, 19, 28, 37, 46)){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GRAY_STAINED_GLASS_PANE).name(" ").get();
            }
        });
        this.addButton(new Button(9){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.COMPASS).name((String)LANGUAGE_MANAGER.getMessage("menu.general_button.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.general_button.lore.not_viewing")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new GeneralSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager);
            }
        });
        this.addButton(new Button(27){

            @Override
            public ItemStack getItem() {
                Material mat;
                switch (MentionTypeSettingsMenu.this.mentionType) {
                    case PLAYER: {
                        mat = Material.PLAYER_HEAD;
                        break;
                    }
                    case EVERYONE: {
                        mat = Material.BEACON;
                        break;
                    }
                    case NEARBY: {
                        mat = MentionTypeSettingsMenu.this.plugin.getMaterial(DMaterial.SPYGLASS, DMaterial.TARGET);
                        break;
                    }
                    case GROUP: {
                        mat = Material.GREEN_BANNER;
                        break;
                    }
                    default: {
                        mat = Material.BELL;
                    }
                }
                return ItemCreator.of(mat).name((String)LANGUAGE_MANAGER.getMessage("menu.mention_button.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.mention_button.lore.go_back")).enchant(MentionTypeSettingsMenu.this.plugin.getEnchantment(DEnchantment.UNBREAKING, DEnchantment.DURABILITY), 1).hideFlag(ItemFlag.values()).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new MentionSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager);
            }
        });
        this.addButton(new Button(47){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BARRIER).name((String)LANGUAGE_MANAGER.getMessage("menu.reset_changes.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.reset_changes.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                MentionTypeSettingsMenu.this.manager.resetChanges();
                MentionTypeSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(53){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.WRITABLE_BOOK).name((String)LANGUAGE_MANAGER.getMessage("menu.save_changes.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.save_changes.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                MentionTypeSettingsMenu.this.manager.saveChanges();
                MentionTypeSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(12){
            final String configPath;
            final String changed;
            final String langPathName = "enabled";
            {
                super(slot);
                this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "enabled", MentionTypeSettingsMenu.this.group);
                this.changed = MentionTypeSettingsMenu.this.manager.isValueChanged(this.configPath) ? "changed" : "unchanged";
                this.langPathName = "enabled";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.LEVER).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "enabled.display_name." + langMentionKey)).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "enabled.lore." + this.changed, this.configPath, MentionTypeSettingsMenu.this.configManager)).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.player, this.configPath, (String)LANGUAGE_MANAGER.getMessage(menuSection, "enabled.edit_title"), text -> {
                    MentionTypeSettingsMenu.this.manager.setUValue(this.configPath, Boolean.valueOf(text));
                    new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                });
            }
        });
        this.addButton(new Button(14){
            final String configPath;
            final String changed;
            final String langPathName = "permission";
            {
                super(slot);
                this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "permission", MentionTypeSettingsMenu.this.group);
                this.changed = MentionTypeSettingsMenu.this.manager.isValueChanged(this.configPath) ? "changed" : "unchanged";
                this.langPathName = "permission";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.PAPER).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "permission.display_name." + langMentionKey)).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "permission.lore." + this.changed, this.configPath, MentionTypeSettingsMenu.this.configManager)).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.player, this.configPath, (String)LANGUAGE_MANAGER.getMessage(menuSection, "permission.edit_title"), text -> {
                    MentionTypeSettingsMenu.this.manager.setUValue(this.configPath, text);
                    new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                });
            }
        });
        this.addButton(new Button(16){
            final String configPath;
            final String changed;
            final String langPathName = "sound";
            {
                super(slot);
                this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "sound", MentionTypeSettingsMenu.this.group);
                this.changed = MentionTypeSettingsMenu.this.manager.isValueChanged(this.configPath) ? "changed" : "unchanged";
                this.langPathName = "sound";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.NOTE_BLOCK).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "sound.display_name")).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "sound.lore." + this.changed, this.configPath, MentionTypeSettingsMenu.this.configManager)).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.player, this.configPath, (String)LANGUAGE_MANAGER.getMessage(menuSection, "sound.edit_title"), text -> {
                    MentionTypeSettingsMenu.this.manager.setUValue(this.configPath, text);
                    new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                });
            }
        });
        if (this.mentionType != MentionType.PLAYER) {
            this.addButton(new Button(30){
                final String configPath;
                final String changed;
                final String langPathName = "keyword";
                {
                    super(slot);
                    this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "keyword", MentionTypeSettingsMenu.this.group);
                    this.changed = MentionTypeSettingsMenu.this.manager.isValueChanged(this.configPath) ? "changed" : "unchanged";
                    this.langPathName = "keyword";
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.NAME_TAG).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "keyword.display_name." + langMentionKey)).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "keyword.lore." + this.changed, this.configPath, MentionTypeSettingsMenu.this.configManager)).get();
                }

                @Override
                public void onClick(Player p, ClickType clickType) {
                    new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.player, this.configPath, (String)LANGUAGE_MANAGER.getMessage(menuSection, "keyword.edit_title"), text -> {
                        MentionTypeSettingsMenu.this.manager.setUValue(this.configPath, text);
                        new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                    });
                }
            });
        }
        this.addButton(new Button(32){
            final String configPath;
            final String changed;
            final String langPathName = "display";
            {
                super(slot);
                this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "display", MentionTypeSettingsMenu.this.group);
                this.changed = MentionTypeSettingsMenu.this.manager.isValueChanged(this.configPath) ? "changed" : "unchanged";
                this.langPathName = "display";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.ITEM_FRAME).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "display.display_name")).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "display.lore." + this.changed, this.configPath, MentionTypeSettingsMenu.this.configManager)).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.player, this.configPath, (String)LANGUAGE_MANAGER.getMessage(menuSection, "display.edit_title"), text -> {
                    MentionTypeSettingsMenu.this.manager.setUValue(this.configPath, text);
                    new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                });
            }
        });
        this.addButton(new Button(34){
            final String configPath;
            final String changed;
            final String langPathName = "cooldown";
            {
                super(slot);
                this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "cooldown", MentionTypeSettingsMenu.this.group);
                this.changed = MentionTypeSettingsMenu.this.manager.isValueChanged(this.configPath) ? "changed" : "unchanged";
                this.langPathName = "cooldown";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CLOCK).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "cooldown.display_name")).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "cooldown.lore." + this.changed, this.configPath, MentionTypeSettingsMenu.this.configManager)).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.player, this.configPath, (String)LANGUAGE_MANAGER.getMessage(menuSection, "cooldown.edit_title"), text -> {
                    MentionTypeSettingsMenu.this.manager.setUValue(this.configPath, MentionTypeSettingsMenu.this.plugin.parseInt((String)text));
                    new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                });
            }
        });
        if (this.mentionType == MentionType.PLAYER) {
            this.addButton(new Button(51){
                final String configPath;
                final String changed;
                final String langPathName = "customized_display";
                {
                    super(slot);
                    this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "customized_display", MentionTypeSettingsMenu.this.group);
                    this.changed = MentionTypeSettingsMenu.this.manager.isValueChanged(this.configPath) ? "changed" : "unchanged";
                    this.langPathName = "customized_display";
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(MentionTypeSettingsMenu.this.plugin.getMaterial(DMaterial.GLOW_ITEM_FRAME, DMaterial.PAINTING)).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "customized_display.display_name")).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "customized_display.lore." + this.changed, this.configPath, MentionTypeSettingsMenu.this.configManager)).get();
                }

                @Override
                public void onClick(Player p, ClickType clickType) {
                    new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.player, this.configPath, (String)LANGUAGE_MANAGER.getMessage(menuSection, "customized_display.edit_title"), text -> {
                        MentionTypeSettingsMenu.this.manager.setUValue(this.configPath, text);
                        new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                    });
                }
            });
        } else if (this.mentionType == MentionType.GROUP) {
            this.addButton(new Button(51){
                final String langPathName = "add_delete_group";
                {
                    super(slot);
                    this.langPathName = "add_delete_group";
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.BLACK_BANNER).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "add_delete_group.display_name")).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "add_delete_group.lore")).get();
                }

                @Override
                public void onClick(Player p, ClickType clickType) {
                    if (clickType == ClickType.LEFT) {
                        new SubMentionAddGroupMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager);
                    } else if (clickType == ClickType.RIGHT) {
                        MentionTypeSettingsMenu.this.manager.setUValue("group.list." + MentionTypeSettingsMenu.this.group, null);
                        new MentionSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager);
                    }
                }
            });
            this.addButton(new Button(49){
                final String langPathName = "disabled_groups";
                {
                    super(slot);
                    this.langPathName = "disabled_groups";
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.REDSTONE).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "disabled_groups.display_name")).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "disabled_groups.lore")).get();
                }

                @Override
                public void onClick(Player p, ClickType clickType) {
                    new SubDisabledGroupsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager);
                }
            });
        } else if (this.mentionType == MentionType.NEARBY) {
            this.addButton(new Button(51){
                final String configPath;
                final String changed;
                final String langPathName = "radius";
                {
                    super(slot);
                    this.configPath = MentionTypeSettingsMenu.this.getPath(MentionTypeSettingsMenu.this.mentionType, "radius", MentionTypeSettingsMenu.this.group);
                    this.changed = MentionTypeSettingsMenu.this.manager.isValueChanged(this.configPath) ? "changed" : "unchanged";
                    this.langPathName = "radius";
                }

                @Override
                public ItemStack getItem() {
                    return ItemCreator.of(Material.ENDER_PEARL).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "radius.display_name")).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "radius.lore." + this.changed, this.configPath, MentionTypeSettingsMenu.this.configManager)).get();
                }

                @Override
                public void onClick(Player p, ClickType clickType) {
                    new AnvilManager(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.player, this.configPath, (String)LANGUAGE_MANAGER.getMessage(menuSection, "radius.edit_title"), text -> {
                        MentionTypeSettingsMenu.this.manager.setUValue(this.configPath, MentionTypeSettingsMenu.this.plugin.parseInt((String)text));
                        new MentionTypeSettingsMenu(MentionTypeSettingsMenu.this.plugin, MentionTypeSettingsMenu.this.player, MentionTypeSettingsMenu.this.manager, MentionTypeSettingsMenu.this.mentionType, MentionTypeSettingsMenu.this.group);
                    });
                }
            });
        }
        this.runOnClose(inv -> {
            this.plugin.GUI_CONFIG_EDITOR = null;
        });
        this.displayTo(this.player);
        this.plugin.GUI_CONFIG_EDITOR = this.player;
    }

    private String getPath(MentionType mentionType, String path, String group) {
        if (mentionType == MentionType.GROUP && this.insiderVar.contains(path)) {
            return mentionType.toString().toLowerCase() + ".list." + group + "." + path;
        }
        return mentionType.toString().toLowerCase() + "." + path;
    }
}

