/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.LazyButton;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.dapi.object.DEnchantment;
import org.nandayo.dapi.object.DMaterial;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.mention.MentionType;
import org.nandayo.dmentions.menu.GeneralSettingsMenu;
import org.nandayo.dmentions.menu.MentionTypeSettingsMenu;
import org.nandayo.dmentions.menu.SubChooseGroupMenu;
import org.nandayo.dmentions.service.GUIManager;
import org.nandayo.dmentions.service.LanguageManager;

public class MentionSettingsMenu
extends Menu {
    private final DMentions plugin;
    private final Player player;
    private final GUIManager manager;

    public MentionSettingsMenu(DMentions plugin, Player player, GUIManager manager) {
        this.plugin = plugin;
        this.player = player;
        this.manager = manager;
        this.open();
    }

    public void open() {
        final LanguageManager LANGUAGE_MANAGER = this.plugin.LANGUAGE_MANAGER;
        final ConfigurationSection menuSection = LANGUAGE_MANAGER.getSection("menu.mention_settings_menu");
        this.createInventory(54, (String)LANGUAGE_MANAGER.getMessage(menuSection, "title"));
        this.addLazyButton(new LazyButton(Arrays.asList(1, 10, 19, 28, 37, 46)){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GRAY_STAINED_GLASS_PANE).name(" ").get();
            }
        });
        this.addButton(new Button(9){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.COMPASS).name((String)LANGUAGE_MANAGER.getMessage("menu.general_button.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.general_button.lore.not_viewing")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new GeneralSettingsMenu(MentionSettingsMenu.this.plugin, MentionSettingsMenu.this.player, MentionSettingsMenu.this.manager);
            }
        });
        this.addButton(new Button(27){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BELL).name((String)LANGUAGE_MANAGER.getMessage("menu.mention_button.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.mention_button.lore.viewing")).enchant(MentionSettingsMenu.this.plugin.getEnchantment(DEnchantment.UNBREAKING, DEnchantment.DURABILITY), 1).hideFlag(ItemFlag.values()).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
            }
        });
        this.addButton(new Button(47){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BARRIER).name((String)LANGUAGE_MANAGER.getMessage("menu.reset_changes.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.reset_changes.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                MentionSettingsMenu.this.manager.resetChanges();
                MentionSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(53){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.WRITABLE_BOOK).name((String)LANGUAGE_MANAGER.getMessage("menu.save_changes.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.save_changes.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                MentionSettingsMenu.this.manager.saveChanges();
                MentionSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(12){
            final String langPathName = "player_mentions";
            {
                super(slot);
                this.langPathName = "player_mentions";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.PLAYER_HEAD).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "player_mentions.display_name")).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "player_mentions.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new MentionTypeSettingsMenu(MentionSettingsMenu.this.plugin, MentionSettingsMenu.this.player, MentionSettingsMenu.this.manager, MentionType.PLAYER, null);
            }
        });
        this.addButton(new Button(14){
            final String langPathName = "everyone_mentions";
            {
                super(slot);
                this.langPathName = "everyone_mentions";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BEACON).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "everyone_mentions.display_name")).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "everyone_mentions.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new MentionTypeSettingsMenu(MentionSettingsMenu.this.plugin, MentionSettingsMenu.this.player, MentionSettingsMenu.this.manager, MentionType.EVERYONE, null);
            }
        });
        this.addButton(new Button(16){
            final String langPathName = "nearby_mentions";
            {
                super(slot);
                this.langPathName = "nearby_mentions";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(MentionSettingsMenu.this.plugin.getMaterial(DMaterial.SPYGLASS, DMaterial.TARGET)).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "nearby_mentions.display_name")).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "nearby_mentions.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new MentionTypeSettingsMenu(MentionSettingsMenu.this.plugin, MentionSettingsMenu.this.player, MentionSettingsMenu.this.manager, MentionType.NEARBY, null);
            }
        });
        this.addButton(new Button(30){
            final String langPathName = "group_mentions";
            {
                super(slot);
                this.langPathName = "group_mentions";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GREEN_BANNER).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "group_mentions.display_name")).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "group_mentions.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new SubChooseGroupMenu(MentionSettingsMenu.this.plugin, MentionSettingsMenu.this.player, MentionSettingsMenu.this.manager);
            }
        });
        this.runOnClose(inv -> {
            this.plugin.GUI_CONFIG_EDITOR = null;
        });
        this.displayTo(this.player);
        this.plugin.GUI_CONFIG_EDITOR = this.player;
    }
}

