/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.menu;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.nandayo.dapi.ItemCreator;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.LazyButton;
import org.nandayo.dapi.guimanager.Menu;
import org.nandayo.dapi.object.DEnchantment;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.menu.AnvilManager;
import org.nandayo.dmentions.menu.MentionSettingsMenu;
import org.nandayo.dmentions.menu.SubDisabledWorldsMenu;
import org.nandayo.dmentions.menu.SubLanguageMenu;
import org.nandayo.dmentions.menu.SubSuffixMenu;
import org.nandayo.dmentions.service.ConfigManager;
import org.nandayo.dmentions.service.GUIManager;
import org.nandayo.dmentions.service.LanguageManager;

public class GeneralSettingsMenu
extends Menu {
    private final DMentions plugin;
    private final ConfigManager configManager;
    private final Player player;
    private final GUIManager manager;

    public GeneralSettingsMenu(DMentions plugin, Player player, GUIManager manager) {
        this.plugin = plugin;
        this.configManager = plugin.CONFIG_MANAGER;
        this.player = player;
        this.manager = manager;
        this.open();
    }

    public void open() {
        final LanguageManager LANGUAGE_MANAGER = this.plugin.LANGUAGE_MANAGER;
        final ConfigurationSection menuSection = LANGUAGE_MANAGER.getSection("menu.general_settings_menu");
        this.createInventory(54, (String)LANGUAGE_MANAGER.getMessage(menuSection, "title"));
        this.addLazyButton(new LazyButton(Arrays.asList(1, 10, 19, 28, 37, 46)){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GRAY_STAINED_GLASS_PANE).name(" ").get();
            }
        });
        this.addButton(new Button(9){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.COMPASS).name((String)LANGUAGE_MANAGER.getMessage("menu.general_button.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.general_button.lore.viewing")).enchant(GeneralSettingsMenu.this.plugin.getEnchantment(DEnchantment.UNBREAKING, DEnchantment.DURABILITY), 1).hideFlag(ItemFlag.values()).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
            }
        });
        this.addButton(new Button(27){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BELL).name((String)LANGUAGE_MANAGER.getMessage("menu.mention_button.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.mention_button.lore.not_viewing")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new MentionSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, GeneralSettingsMenu.this.manager);
            }
        });
        this.addButton(new Button(47){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BARRIER).name((String)LANGUAGE_MANAGER.getMessage("menu.reset_changes.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.reset_changes.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                GeneralSettingsMenu.this.manager.resetChanges();
                GeneralSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(53){

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.WRITABLE_BOOK).name((String)LANGUAGE_MANAGER.getMessage("menu.save_changes.display_name")).lore((List)LANGUAGE_MANAGER.getMessage("menu.save_changes.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                GeneralSettingsMenu.this.manager.saveChanges();
                GeneralSettingsMenu.this.player.closeInventory();
            }
        });
        this.addButton(new Button(12){
            final String configPath = "lang_file";
            final String changed;
            final String langPathName = "language";
            {
                super(slot);
                this.configPath = "lang_file";
                this.changed = GeneralSettingsMenu.this.manager.isValueChanged("lang_file") ? "changed" : "unchanged";
                this.langPathName = "language";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.BOOK).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "language.display_name")).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "language.lore." + this.changed, "lang_file", GeneralSettingsMenu.this.configManager)).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new SubLanguageMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, GeneralSettingsMenu.this.manager);
            }
        });
        this.addButton(new Button(14){
            final String configPath = "check_for_updates";
            final String changed;
            final String langPathName = "check_for_updates";
            {
                super(slot);
                this.configPath = "check_for_updates";
                this.changed = GeneralSettingsMenu.this.manager.isValueChanged("check_for_updates") ? "changed" : "unchanged";
                this.langPathName = "check_for_updates";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CLOCK).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "check_for_updates.display_name")).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "check_for_updates.lore." + this.changed, "check_for_updates", GeneralSettingsMenu.this.configManager)).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new AnvilManager(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.manager, GeneralSettingsMenu.this.player, "check_for_updates", (String)LANGUAGE_MANAGER.getMessage(menuSection, "check_for_updates.edit_title"), text -> {
                    GeneralSettingsMenu.this.manager.setUValue("check_for_updates", Boolean.valueOf(text));
                    new GeneralSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, GeneralSettingsMenu.this.manager);
                });
            }
        });
        this.addButton(new Button(16){
            final String configPath = "prefix";
            final String changed;
            final String langPathName = "prefix";
            {
                super(slot);
                this.configPath = "prefix";
                this.changed = GeneralSettingsMenu.this.manager.isValueChanged("prefix") ? "changed" : "unchanged";
                this.langPathName = "prefix";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.NAME_TAG).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "prefix.display_name")).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "prefix.lore." + this.changed, "prefix", GeneralSettingsMenu.this.configManager)).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new AnvilManager(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.manager, GeneralSettingsMenu.this.player, "prefix", (String)LANGUAGE_MANAGER.getMessage(menuSection, "prefix.edit_title"), text -> {
                    GeneralSettingsMenu.this.manager.setUValue("prefix", text);
                    new GeneralSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, GeneralSettingsMenu.this.manager);
                });
            }
        });
        this.addButton(new Button(30){
            final String configPath = "mention_limit";
            final String changed;
            final String langPathName = "mention_limit";
            {
                super(slot);
                this.configPath = "mention_limit";
                this.changed = GeneralSettingsMenu.this.manager.isValueChanged("mention_limit") ? "changed" : "unchanged";
                this.langPathName = "mention_limit";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.PAPER).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "mention_limit.display_name")).lore(LANGUAGE_MANAGER.getValueDisplayMessage(menuSection, "mention_limit.lore." + this.changed, "mention_limit", GeneralSettingsMenu.this.configManager)).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new AnvilManager(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.manager, GeneralSettingsMenu.this.player, "mention_limit", (String)LANGUAGE_MANAGER.getMessage(menuSection, "mention_limit.edit_title"), text -> {
                    GeneralSettingsMenu.this.manager.setUValue("mention_limit", GeneralSettingsMenu.this.plugin.parseInt((String)text));
                    new GeneralSettingsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, GeneralSettingsMenu.this.manager);
                });
            }
        });
        this.addButton(new Button(32){
            final String langPathName = "suffix_colors";
            {
                super(slot);
                this.langPathName = "suffix_colors";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.CYAN_DYE).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "suffix_colors.display_name")).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "suffix_colors.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new SubSuffixMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, GeneralSettingsMenu.this.manager);
            }
        });
        this.addButton(new Button(34){
            final String langPathName = "disabled_worlds";
            {
                super(slot);
                this.langPathName = "disabled_worlds";
            }

            @Override
            public ItemStack getItem() {
                return ItemCreator.of(Material.GRASS_BLOCK).name((String)LANGUAGE_MANAGER.getMessage(menuSection, "disabled_worlds.display_name")).lore((List)LANGUAGE_MANAGER.getMessage(menuSection, "disabled_worlds.lore")).get();
            }

            @Override
            public void onClick(Player p, ClickType clickType) {
                new SubDisabledWorldsMenu(GeneralSettingsMenu.this.plugin, GeneralSettingsMenu.this.player, GeneralSettingsMenu.this.manager);
            }
        });
        this.runOnClose(inv -> {
            this.plugin.GUI_CONFIG_EDITOR = null;
        });
        this.displayTo(this.player);
        this.plugin.GUI_CONFIG_EDITOR = this.player;
    }
}

