/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.mention;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.nandayo.dapi.HexUtil;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.integration.LP;
import org.nandayo.dmentions.mention.MentionHolder;
import org.nandayo.dmentions.mention.MentionType;
import org.nandayo.dmentions.mention.event.MentionEveryoneEvent;
import org.nandayo.dmentions.mention.event.MentionGroupEvent;
import org.nandayo.dmentions.mention.event.MentionNearbyEvent;
import org.nandayo.dmentions.mention.event.MentionPlayerEvent;
import org.nandayo.dmentions.service.ConfigManager;
import org.nandayo.dmentions.service.CooldownManager;
import org.nandayo.dmentions.service.MessageManager;

public class MentionManager {
    private final Set<String> validKeywords = new HashSet<String>();
    private final Map<String, MentionHolder> mentionHolders = new HashMap<String, MentionHolder>();
    private String keywordPattern = "";
    private final ConfigManager configManager;
    private final DMentions plugin;

    public MentionManager(DMentions plugin) {
        this.plugin = plugin;
        this.configManager = plugin.CONFIG_MANAGER;
        this.load();
    }

    public void removePlayer(Player player) {
        if (!this.validKeywords.contains(player.getName())) {
            return;
        }
        this.validKeywords.remove(player.getName());
        this.mentionHolders.remove(player.getName());
        this.updateKeywordPattern();
    }

    public void addPlayer(Player player) {
        if (this.validKeywords.contains(player.getName())) {
            return;
        }
        this.validKeywords.add(player.getName());
        String perm = this.plugin.getPermission(this.configManager.getString("player.permission", "dmentions.mention.player"));
        this.mentionHolders.put(player.getName(), new MentionHolder(MentionType.PLAYER, perm, player.getName()));
        this.updateKeywordPattern();
    }

    public void load() {
        String perm;
        String keyword;
        this.mentionHolders.clear();
        this.validKeywords.clear();
        if (this.configManager.getBoolean("player.enabled", false)) {
            Bukkit.getOnlinePlayers().forEach(player -> {
                String keyword = player.getName();
                String perm = this.plugin.getPermission(this.configManager.getString("player.permission", "dmentions.mention.player"));
                this.validKeywords.add(keyword);
                this.mentionHolders.put(keyword, new MentionHolder(MentionType.PLAYER, perm, keyword));
            });
        }
        if (this.configManager.getBoolean("nearby.enabled", false)) {
            keyword = this.configManager.getString("nearby.keyword", "@nearby");
            perm = this.plugin.getPermission(this.configManager.getString("nearby.permission", "dmentions.mention.nearby"));
            this.validKeywords.add(keyword);
            this.mentionHolders.put(keyword, new MentionHolder(MentionType.NEARBY, perm));
        }
        if (this.configManager.getBoolean("everyone.enabled", false)) {
            keyword = this.configManager.getString("everyone.keyword", "@everyone");
            perm = this.plugin.getPermission(this.configManager.getString("everyone.permission", "dmentions.mention.everyone"));
            this.validKeywords.add(keyword);
            this.mentionHolders.put(keyword, new MentionHolder(MentionType.EVERYONE, perm));
        }
        if (this.configManager.getBoolean("group.enabled", false) && LP.isConnected()) {
            List<String> disabledGroups = this.configManager.getStringList("group.disabled_groups");
            String keywordTemplate = this.configManager.getString("group.keyword", "@{group}");
            LP.getGroups().stream().filter(group -> !disabledGroups.contains(group)).forEach(group -> {
                String keyword = keywordTemplate.replace("{group}", (CharSequence)group);
                String perm = this.plugin.getPermission(this.configManager.getString("group.permission", "dmentions.mention.group.{group}")).replace("{group}", (CharSequence)group);
                this.validKeywords.add(keyword);
                this.mentionHolders.put(keyword, new MentionHolder(MentionType.GROUP, perm, (String)group));
            });
        }
        this.updateKeywordPattern();
    }

    private void updateKeywordPattern() {
        this.keywordPattern = this.validKeywords.stream().map(Pattern::quote).collect(Collectors.joining("|"));
    }

    public String getMentionedString(@NotNull DMentions plugin, @NotNull Player sender, @NotNull String message) {
        CooldownManager cooldownManager = plugin.COOLDOWN_MANAGER;
        Pattern mentionPattern = Pattern.compile(String.format("(?<!\\S)(%s)(?=[\\s\\p{P}]|$)", this.keywordPattern));
        Matcher matcher = mentionPattern.matcher(message);
        StringBuilder updatedMessage = new StringBuilder();
        int lastAppendPosition = 0;
        int mentionLimit = this.configManager.getInt("mention_limit", 2);
        int mentionCounter = 0;
        block6: while (matcher.find() && mentionCounter < mentionLimit) {
            String keyword = matcher.group(1);
            MentionHolder mentionHolder = this.mentionHolders.get(keyword);
            if (mentionHolder == null || !sender.hasPermission(mentionHolder.getPerm())) continue;
            long remainedCooldown = cooldownManager.getRemaining(mentionHolder.getType(), mentionHolder.getTarget());
            if (remainedCooldown > 0L) {
                cooldownManager.cooldownWarn(sender, remainedCooldown);
                continue;
            }
            updatedMessage.append(message, lastAppendPosition, matcher.start());
            lastAppendPosition = matcher.end();
            String displayText = keyword;
            String suffixColor = this.getSuffixColor(sender);
            switch (mentionHolder.getType()) {
                case PLAYER: {
                    Player target;
                    if (mentionHolder.getTarget() == null || (target = Bukkit.getPlayerExact((String)mentionHolder.getTarget())) == null || !plugin.USER_MANAGER.getMentionMode(target)) continue block6;
                    if (plugin.isRestricted(sender, target)) {
                        new MessageManager(this.configManager).sendSortedMessage(sender, (String)plugin.LANGUAGE_MANAGER.getMessage("mention_restricted_warn"));
                        continue block6;
                    }
                    displayText = this.getPlayerDisplay(target) + suffixColor;
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MentionPlayerEvent(sender, target)));
                    break;
                }
                case NEARBY: {
                    displayText = this.configManager.getString("nearby.display", "@nearby") + suffixColor;
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MentionNearbyEvent(sender, this.getNearbyPlayers(sender))));
                    break;
                }
                case EVERYONE: {
                    displayText = this.configManager.getString("everyone.display", "@everyone") + suffixColor;
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MentionEveryoneEvent(sender, Bukkit.getOnlinePlayers().toArray(new Player[0]))));
                    break;
                }
                case GROUP: {
                    ConfigurationSection section;
                    String group = mentionHolder.getTarget();
                    if (group == null || (section = plugin.getConfigGroupSection(group)) == null) continue block6;
                    displayText = section.getString("display", "{group}").replace("{group}", group) + suffixColor;
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> Bukkit.getPluginManager().callEvent((Event)new MentionGroupEvent(sender, group, LP.getOnlinePlayersInGroup(group))));
                }
            }
            ++mentionCounter;
            cooldownManager.updateLastUse(mentionHolder.getType(), mentionHolder.getTarget());
            updatedMessage.append(HexUtil.color(displayText));
        }
        updatedMessage.append(message.substring(lastAppendPosition));
        return updatedMessage.toString();
    }

    private String getPlayerDisplay(@NotNull Player target) {
        String mentionDisplay = this.plugin.USER_MANAGER.getMentionDisplay(target);
        if (mentionDisplay == null || mentionDisplay.isEmpty() || mentionDisplay.equalsIgnoreCase(target.getName())) {
            return this.plugin.CONFIG_MANAGER.getString("player.display", "{p}").replace("{p}", this.plugin.USER_MANAGER.getMentionDisplay(target));
        }
        return this.plugin.CONFIG_MANAGER.getString("player.customized_display", "{display}").replace("{display}", mentionDisplay);
    }

    private String getSuffixColor(@NotNull Player sender) {
        if (LP.isConnected()) {
            String group = LP.getGroup(sender);
            ConfigurationSection section = this.plugin.CONFIG_MANAGER.getConfigurationSection("suffix_color.group");
            if (section != null && section.contains(group)) {
                return section.getString(group, "");
            }
        }
        return this.plugin.CONFIG_MANAGER.getString("suffix_color.group.__OTHER__", "");
    }

    private Player[] getNearbyPlayers(@NotNull Player player) {
        int radius = this.plugin.CONFIG_MANAGER.getInt("nearby.radius", 20);
        if (radius <= 0) {
            return new Player[0];
        }
        HashSet<Player> nearbyPlayers = new HashSet<Player>();
        for (Entity entity : player.getNearbyEntities((double)radius, (double)radius, (double)radius)) {
            if (!(entity instanceof Player)) continue;
            Player nearbyPlayer = (Player)entity;
            nearbyPlayers.add(nearbyPlayer);
        }
        return nearbyPlayers.toArray(new Player[0]);
    }

    @Generated
    public Set<String> getValidKeywords() {
        return this.validKeywords;
    }
}

