/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.integration;

import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.event.EventBus;
import net.luckperms.api.event.node.NodeAddEvent;
import net.luckperms.api.event.node.NodeClearEvent;
import net.luckperms.api.event.node.NodeRemoveEvent;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.types.InheritanceNode;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.nandayo.dmentions.integration.LP;

public class LPEvents {
    private final JavaPlugin plugin;
    private final LuckPerms api;

    public LPEvents(JavaPlugin plugin, LuckPerms api) {
        this.plugin = plugin;
        this.api = api;
    }

    public void register() {
        EventBus eventBus = this.api.getEventBus();
        eventBus.subscribe((Object)this.plugin, NodeAddEvent.class, this::onAdd);
        eventBus.subscribe((Object)this.plugin, NodeRemoveEvent.class, this::onRemove);
        eventBus.subscribe((Object)this.plugin, NodeClearEvent.class, this::onClear);
    }

    private void onAdd(NodeAddEvent event) {
        if (!event.isUser()) {
            return;
        }
        User user = (User)event.getTarget();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (event.getNode() instanceof InheritanceNode) {
                Player player = Bukkit.getPlayer((UUID)user.getUniqueId());
                if (player == null) {
                    return;
                }
                LP.updatePlayerGroupCache(player);
            }
        });
    }

    private void onRemove(NodeRemoveEvent event) {
        if (!event.isUser()) {
            return;
        }
        User user = (User)event.getTarget();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (event.getNode() instanceof InheritanceNode) {
                Player player = Bukkit.getPlayer((UUID)user.getUniqueId());
                if (player == null) {
                    return;
                }
                LP.updatePlayerGroupCache(player);
            }
        });
    }

    private void onClear(NodeClearEvent event) {
        if (!event.isUser()) {
            return;
        }
        User user = (User)event.getTarget();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Player player = Bukkit.getPlayer((UUID)user.getUniqueId());
            if (player == null) {
                return;
            }
            LP.updatePlayerGroupCache(player);
        });
    }
}

