/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions.data;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.nandayo.dmentions.DMentions;
import org.nandayo.dmentions.data.IUser;

public class UserManager
implements IUser {
    private final String ns = "players.";
    private final File file;
    private final FileConfiguration config;
    private final DMentions plugin;

    public UserManager(DMentions plugin) {
        this.plugin = plugin;
        this.file = new File(this.plugin.getDataFolder(), "players.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void saveChanges() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save players.yml. " + e.getMessage());
        }
    }

    @Override
    public boolean getMentionMode(Player player) {
        return this.config.getBoolean("players." + player.getUniqueId() + ".mentions", true);
    }

    @Override
    public void setMentionMode(Player player, boolean mode) {
        this.config.set("players." + player.getUniqueId() + ".mentions", (Object)mode);
    }

    @Override
    public String getMentionDisplay(Player player) {
        return this.config.getString("players." + player.getUniqueId() + ".mention_display", player.getName());
    }

    @Override
    public void setMentionDisplay(Player player, String display) {
        this.config.set("players." + player.getUniqueId() + ".mention_display", (Object)display);
    }
}

