/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.Util;
import org.nandayo.dapi.object.DEnchantment;
import org.nandayo.dapi.object.DMaterial;
import org.nandayo.dmentions.Config;
import org.nandayo.dmentions.MainCommand;
import org.nandayo.dmentions.bstats.bukkit.Metrics;
import org.nandayo.dmentions.data.UserManager;
import org.nandayo.dmentions.integration.LP;
import org.nandayo.dmentions.integration.LPEvents;
import org.nandayo.dmentions.mention.MentionManager;
import org.nandayo.dmentions.mention.MentionType;
import org.nandayo.dmentions.mention.PluginEvents;
import org.nandayo.dmentions.service.ConfigManager;
import org.nandayo.dmentions.service.CooldownManager;
import org.nandayo.dmentions.service.LanguageManager;
import org.nandayo.dmentions.service.MessageManager;
import org.nandayo.dmentions.service.PermissionManager;
import org.nandayo.dmentions.service.UpdateChecker;
import org.nandayo.dmentions.service.Wrapper;

public final class DMentions
extends JavaPlugin
implements Listener {
    private static DMentions plugin;
    public final List<String> afterLoadPermissions = new ArrayList<String>();
    public Wrapper WRAPPER;
    public Config CONFIG;
    public ConfigManager CONFIG_MANAGER;
    public MentionManager MENTION_MANAGER;
    public UserManager USER_MANAGER;
    public CooldownManager COOLDOWN_MANAGER;
    public LanguageManager LANGUAGE_MANAGER;
    public PermissionManager PERMISSION_MANAGER = null;
    public Player GUI_CONFIG_EDITOR = null;

    public static DMentions inst() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)this);
        pm.registerEvents((Listener)new PluginEvents(), (Plugin)this);
        DAPI dapi = new DAPI((Plugin)plugin);
        dapi.registerMenuListener();
        Util.PREFIX = "&7[&eDMentions&7]&r ";
        Objects.requireNonNull(this.getCommand("dmentions")).setExecutor((CommandExecutor)new MainCommand());
        if (pm.getPlugin("LuckPerms") != null) {
            new LP(this);
            new LPEvents(this, LP.getApi()).register();
            Util.log("&aLuckPerms found. Integration has been enabled!");
        } else {
            Util.log("&fLuckPerms not found. Skipping integration.");
        }
        this.updateVariables();
        if (this.CONFIG_MANAGER.getBoolean("check_for_updates", true)) {
            new UpdateChecker((Plugin)this, 121452).getVersion(version -> {
                if (this.getDescription().getVersion().equals(version)) {
                    Util.log("&aPlugin is up-to-date.");
                } else {
                    Util.log("&fThere is a new version update. (&e" + version + "&f)");
                }
            });
        }
        new Metrics((Plugin)this, 24381);
    }

    public void onDisable() {
        this.USER_MANAGER.saveChanges();
    }

    public void updateVariables() {
        this.WRAPPER = new Wrapper(this);
        this.CONFIG = new Config(this).updateConfig();
        this.CONFIG_MANAGER = new ConfigManager(this.CONFIG.get());
        this.MENTION_MANAGER = new MentionManager(this);
        if (this.USER_MANAGER != null) {
            this.USER_MANAGER.saveChanges();
        }
        this.USER_MANAGER = new UserManager(this);
        this.COOLDOWN_MANAGER = new CooldownManager(this);
        this.COOLDOWN_MANAGER.updateConfigCooldowns();
        this.LANGUAGE_MANAGER = new LanguageManager(this, new File(this.getDataFolder(), "lang"), this.CONFIG_MANAGER.getString("lang_file", "en-US"));
        if (this.PERMISSION_MANAGER == null) {
            this.PERMISSION_MANAGER = new PermissionManager(this);
            this.PERMISSION_MANAGER.clearAfterLoadPermissions();
            this.PERMISSION_MANAGER.setupPermissions();
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.MENTION_MANAGER.addPlayer(event.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.MENTION_MANAGER.removePlayer(event.getPlayer());
        this.COOLDOWN_MANAGER.removeCooldown(MentionType.PLAYER, event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChat(AsyncPlayerChatEvent e) {
        Player sender = e.getPlayer();
        String message = e.getMessage();
        if (e.isCancelled()) {
            return;
        }
        List<String> disabledWorlds = this.CONFIG_MANAGER.getStringList("disabled_worlds");
        if (disabledWorlds != null && disabledWorlds.contains(sender.getWorld().getName())) {
            new MessageManager(this.CONFIG_MANAGER).sendSortedMessage(sender, (String)this.LANGUAGE_MANAGER.getMessage("disabled_world_warn"));
            return;
        }
        String mentionedString = this.MENTION_MANAGER.getMentionedString(this, sender, message);
        e.setMessage(mentionedString);
    }

    public Material getMaterial(@NotNull DMaterial dMaterial, @NotNull DMaterial def) {
        Material mat = dMaterial.get();
        if (mat != null) {
            return mat;
        }
        return def.get();
    }

    public Enchantment getEnchantment(@NotNull DEnchantment dEnchantment, @NotNull DEnchantment def) {
        Enchantment mat = dEnchantment.get();
        if (mat != null) {
            return mat;
        }
        return def.get();
    }

    public boolean isRestricted(@NotNull Player sender, @NotNull Player target) {
        if (target.hasPermission("dmentions.mention.restricted")) {
            return !sender.hasPermission("dmentions.mention.restricted.bypass");
        }
        return false;
    }

    public ConfigurationSection getConfigGroupSection(@NotNull String groupName) {
        if (groupName.isEmpty()) {
            return null;
        }
        if (this.CONFIG_MANAGER.getStringList("group.disabled_groups").contains(groupName)) {
            return null;
        }
        return this.CONFIG_MANAGER.getConfigurationSection("group.list." + this.getGroupConfigTitle(groupName));
    }

    public ConfigurationSection getLanguageGroupSection(@NotNull String groupName) {
        return this.LANGUAGE_MANAGER.getSection("group." + this.getGroupConfigTitle(groupName));
    }

    @NotNull
    public String getGroupConfigTitle(@Nullable String groupName) {
        if (groupName == null) {
            return "__OTHER__";
        }
        ConfigurationSection section = this.CONFIG_MANAGER.getConfigurationSection("group.list");
        if (section == null || !section.contains(groupName)) {
            return "__OTHER__";
        }
        return groupName;
    }

    public String getPermission(String str) {
        return str == null || str.isEmpty() ? "" : str;
    }

    public String formattedTime(long millisecond) {
        long seconds = millisecond / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        seconds %= 60L;
        minutes %= 60L;
        hours %= 24L;
        if (days > 0L) {
            return String.format("%d d, %d h", days, hours);
        }
        if (hours > 0L) {
            return String.format("%d h, %d m", hours, minutes);
        }
        if (minutes > 0L) {
            return String.format("%d m, %d s", minutes, seconds);
        }
        return String.format("%d s", seconds);
    }

    public int parseInt(@NotNull String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

