/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dmentions;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.nandayo.dapi.Util;
import org.nandayo.dmentions.DMentions;

public class Config {
    private static File file;
    private static FileConfiguration config;
    private final DMentions plugin;

    public FileConfiguration get() {
        return config;
    }

    public Config(DMentions plugin) {
        this.plugin = plugin;
        file = new File(this.plugin.getDataFolder(), "config.yml");
        if (!file.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public Config updateConfig() {
        String configVersion;
        String version = this.plugin.getDescription().getVersion();
        if (version.equals(configVersion = config.getString("config_version", "0"))) {
            return this;
        }
        InputStream defStream = this.plugin.getResource("config.yml");
        if (defStream == null) {
            Util.log("&cDefault config.yml not found in plugin resources.");
            return this;
        }
        this.saveBackupConfig();
        YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defStream));
        for (Object key : defConfig.getKeys(true)) {
            if (((String)key).startsWith("suffix_color.group") || ((String)key).startsWith("disabled_worlds") || ((String)key).startsWith("group.disabled_groups") || ((String)key).startsWith("group.list") || defConfig.isConfigurationSection((String)key) || !config.contains((String)key)) continue;
            defConfig.set((String)key, config.get((String)key));
        }
        defConfig.set("suffix_color.group", null);
        ConfigurationSection suffixSection = config.getConfigurationSection("suffix_color.group");
        if (suffixSection != null) {
            for (String group : suffixSection.getKeys(true)) {
                defConfig.set(suffixSection.getCurrentPath() + "." + group, (Object)suffixSection.getString(group));
            }
        }
        defConfig.set("disabled_worlds", (Object)config.getStringList("disabled_worlds"));
        defConfig.set("group.disabled_groups", (Object)config.getStringList("group.disabled_groups"));
        ConfigurationSection groupSection = config.getConfigurationSection("group.list");
        ConfigurationSection keySection = defConfig.getConfigurationSection("group.list.default");
        Set keys = keySection != null ? keySection.getKeys(true) : new HashSet();
        defConfig.set("group.list", null);
        if (groupSection != null) {
            for (String group : groupSection.getKeys(false)) {
                for (String key : keys) {
                    if (config.isConfigurationSection(group + "." + key)) continue;
                    defConfig.set(groupSection.getCurrentPath() + "." + group + "." + key, groupSection.get(group + "." + key));
                }
            }
        }
        try {
            defConfig.set("config_version", (Object)version);
            defConfig.save(file);
            config = defConfig;
            Util.log("&aUpdated config file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save updated config file.");
            e.printStackTrace();
        }
        return this;
    }

    private void saveBackupConfig() {
        File backupDir = new File(this.plugin.getDataFolder(), "backups");
        if (!backupDir.exists()) {
            backupDir.mkdirs();
        }
        String date = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        File backupFile = new File(backupDir, "config_" + date + ".yml");
        try {
            config.save(backupFile);
            Util.log("&aBacked up old config file.");
        }
        catch (Exception e) {
            Util.log("&cFailed to save backup file.");
            e.printStackTrace();
        }
    }
}

