/*
 * Decompiled with CFR 0.152.
 */
package org.nandayo.dapi.guimanager;

import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.MetadataValue;
import org.nandayo.dapi.DAPI;
import org.nandayo.dapi.guimanager.Button;
import org.nandayo.dapi.guimanager.Menu;

public class MenuListener
implements Listener {
    @EventHandler
    public void onGUIClick(InventoryClickEvent e) {
        DAPI dapi = DAPI.getInstance();
        if (dapi.plugin == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (p.hasMetadata(dapi.GUI_METADATA_KEY)) {
            Menu menu = (Menu)((MetadataValue)p.getMetadata(dapi.GUI_METADATA_KEY).get(0)).value();
            if (menu == null) {
                return;
            }
            if (menu.isEmptySlotsModifiable() && Objects.equals(e.getClickedInventory(), p.getInventory())) {
                return;
            }
            if (Objects.equals(e.getClickedInventory(), p.getInventory())) {
                e.setCancelled(true);
                return;
            }
            Button button = menu.getButton(e.getSlot());
            if (button != null) {
                e.setCancelled(!button.isModifiable());
                button.onClick(p, e.getClick());
            } else {
                e.setCancelled(!menu.isEmptySlotsModifiable());
            }
        }
    }

    @EventHandler
    public void onGUIDrag(InventoryDragEvent e) {
        Menu menu;
        DAPI dapi = DAPI.getInstance();
        if (dapi.plugin == null) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (p.hasMetadata(dapi.GUI_METADATA_KEY) && (menu = (Menu)((MetadataValue)p.getMetadata(dapi.GUI_METADATA_KEY).get(0)).value()) != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onGUIClose(InventoryCloseEvent e) {
        DAPI dapi = DAPI.getInstance();
        if (dapi.plugin == null) {
            return;
        }
        Player p = (Player)e.getPlayer();
        if (p.hasMetadata(dapi.GUI_METADATA_KEY)) {
            Menu menu = (Menu)((MetadataValue)p.getMetadata(dapi.GUI_METADATA_KEY).get(0)).value();
            if (menu != null) {
                menu.handleCloseCallback();
            }
            p.removeMetadata(dapi.GUI_METADATA_KEY, dapi.plugin);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        DAPI dapi = DAPI.getInstance();
        if (dapi.plugin == null) {
            return;
        }
        Player p = e.getPlayer();
        if (p.hasMetadata(dapi.GUI_METADATA_KEY)) {
            Menu menu = (Menu)((MetadataValue)p.getMetadata(dapi.GUI_METADATA_KEY).get(0)).value();
            if (menu != null) {
                menu.handleCloseCallback();
            }
            p.removeMetadata(dapi.GUI_METADATA_KEY, dapi.plugin);
        }
    }
}

