/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.modules;

import coolcostupit.openjs.events.ScriptLoadedEvent;
import coolcostupit.openjs.events.ScriptUnloadedEvent;
import coolcostupit.openjs.logging.ScriptLogger;
import coolcostupit.openjs.logging.pluginLogger;
import coolcostupit.openjs.modules.EventListenerWrapper;
import coolcostupit.openjs.modules.FoliaSupport;
import coolcostupit.openjs.modules.PublicVarManager;
import coolcostupit.openjs.modules.ScriptEngine;
import coolcostupit.openjs.utility.FlagInterpreter;
import coolcostupit.openjs.utility.VariableStorage;
import coolcostupit.openjs.utility.configurationUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptException;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class scriptWrapper {
    private boolean scriptsReady;
    private boolean hasInit;
    private final Map<String, List<Listener>> eventListenersMap;
    private final Map<String, List<Integer>> scriptTasksMap;
    private final Map<String, Future<?>> scriptFutures;
    private final Map<String, javax.script.ScriptEngine> scriptEngines;
    private final Map<String, List<Command>> scriptCommands;
    private final JavaPlugin plugin;
    private final File disabledScriptsFile;
    private final pluginLogger pluginLogger;
    private final PublicVarManager PublicVarManager;
    private final configurationUtil configUtil;
    private final VariableStorage variableStorage;
    public final List<String> disabledScripts;
    public final List<String> activeFiles;
    public final List<String> runningScripts;
    public final ExecutorService executorService;

    public scriptWrapper(JavaPlugin plugin, configurationUtil configUtil) {
        boolean scriptsFolderCreated;
        File scriptsFolder;
        block10: {
            this.scriptsReady = false;
            this.hasInit = false;
            this.eventListenersMap = new HashMap<String, List<Listener>>();
            this.scriptTasksMap = new HashMap<String, List<Integer>>();
            this.scriptFutures = new HashMap();
            this.scriptEngines = new HashMap<String, javax.script.ScriptEngine>();
            this.scriptCommands = new HashMap<String, List<Command>>();
            this.disabledScripts = new ArrayList<String>();
            this.activeFiles = new ArrayList<String>();
            this.runningScripts = new ArrayList<String>();
            this.plugin = plugin;
            this.pluginLogger = new pluginLogger(plugin, configUtil);
            this.PublicVarManager = new PublicVarManager();
            this.configUtil = configUtil;
            this.variableStorage = new VariableStorage(plugin);
            this.executorService = Executors.newCachedThreadPool();
            if (!this.hasInit) {
                this.hasInit = true;
                FoliaSupport.ScheduleTask(plugin, () -> {
                    this.scriptsReady = true;
                }, 20L);
            }
            scriptsFolder = new File(plugin.getDataFolder(), "scripts");
            scriptsFolderCreated = scriptsFolder.mkdirs();
            this.disabledScriptsFile = new File(plugin.getDataFolder(), "disabledscripts.json");
            if (!this.disabledScriptsFile.exists()) {
                try {
                    boolean fileCreated = this.disabledScriptsFile.createNewFile();
                    if (!fileCreated) break block10;
                    try (FileWriter writer = new FileWriter(this.disabledScriptsFile);){
                        writer.write("[]");
                    }
                }
                catch (IOException e) {
                    this.pluginLogger.log(Level.SEVERE, "Failed to create disabledscripts.json." + e.getMessage(), "\u001b[31m");
                }
            }
        }
        if (!scriptsFolderCreated && !scriptsFolder.exists()) {
            this.pluginLogger.log(Level.WARNING, "Failed to create scripts folder.", "\u001b[38;5;214m");
        }
    }

    public boolean isJavascriptFileActive(String fileName) {
        return this.activeFiles.contains(fileName);
    }

    public boolean isJavascriptFileRunning(String fileName) {
        return this.runningScripts.contains(fileName);
    }

    public List<Listener> getEventListenersFromScript(String scriptName) {
        return this.eventListenersMap.getOrDefault(scriptName, null);
    }

    public void unregisterListener(Listener listener, String scriptName) {
        HandlerList.unregisterAll((Listener)listener);
        List<Listener> listeners = this.eventListenersMap.get(scriptName);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.eventListenersMap.remove(scriptName);
            }
        }
    }

    public void unregisterListenersFromScript(String scriptName) {
        List<Listener> activeListeners = this.getEventListenersFromScript(scriptName);
        if (activeListeners != null) {
            ArrayList<Listener> listenersToRemove = new ArrayList<Listener>(activeListeners);
            for (Listener listener : listenersToRemove) {
                this.unregisterListener(listener, scriptName);
            }
        }
    }

    public void unregisterTasksFromScript(String scriptName) {
        List<Integer> taskIds = this.scriptTasksMap.get(scriptName);
        if (taskIds != null) {
            for (int taskId : taskIds) {
                FoliaSupport.CancelTask(taskId);
            }
            this.scriptTasksMap.remove(scriptName);
        }
    }

    public void unloadAllScripts() {
        for (String scriptName : new ArrayList<String>(this.activeFiles)) {
            this.unloadScript(scriptName);
        }
    }

    public void unregisterAllTasks() {
        for (List<Integer> taskIds : this.scriptTasksMap.values()) {
            for (int taskId : taskIds) {
                Bukkit.getServer().getScheduler().cancelTask(taskId);
            }
        }
        this.scriptTasksMap.clear();
    }

    public void loadDisabledScripts() {
        try (FileReader reader = new FileReader(this.disabledScriptsFile);){
            JSONParser parser = new JSONParser();
            JSONArray jsonArray = (JSONArray)parser.parse((Reader)reader);
            for (Object obj : jsonArray) {
                this.disabledScripts.add((String)obj);
            }
        }
        catch (IOException | ParseException e) {
            this.pluginLogger.log(Level.SEVERE, "Failed to load disabled scripts." + e.getMessage(), "\u001b[31m");
        }
    }

    public void unregisterAllListeners() {
        for (Map.Entry<String, List<Listener>> entry : this.eventListenersMap.entrySet()) {
            List<Listener> listeners = entry.getValue();
            for (Listener listener : listeners) {
                HandlerList.unregisterAll((Listener)listener);
            }
        }
        this.eventListenersMap.clear();
    }

    public CommandMap getCommandMap() {
        CommandMap commandMap = null;
        try {
            Field f = Bukkit.getPluginManager().getClass().getDeclaredField("commandMap");
            f.setAccessible(true);
            commandMap = (CommandMap)f.get(Bukkit.getPluginManager());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return commandMap;
    }

    private void removeCommandFromKnownCommands(String commandName) throws Exception {
        CommandMap commandMap = this.getCommandMap();
        Field knownCommandsField = SimpleCommandMap.class.getDeclaredField("knownCommands");
        knownCommandsField.setAccessible(true);
        Map knownCommands = (Map)knownCommandsField.get(commandMap);
        knownCommands.remove(commandName);
    }

    private void invokeSyncCommands() {
        try {
            Class<?> serverClass = Bukkit.getServer().getClass();
            Method method = this.getMethod(serverClass, "syncCommands");
            method.setAccessible(true);
            method.invoke((Object)Bukkit.getServer(), new Object[0]);
            method.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        try {
            return clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return this.getMethod(superClass, methodName);
        }
    }

    public void unregisterCommands(String scriptName) {
        List<Command> commands = this.scriptCommands.remove(scriptName);
        if (commands != null) {
            try {
                CommandMap commandMap = this.getCommandMap();
                for (Command dynamicCommand : commands) {
                    this.removeCommandFromKnownCommands(dynamicCommand.getName());
                    boolean Unregistered = dynamicCommand.unregister(commandMap);
                    if (Unregistered) {
                        this.pluginLogger.log(Level.INFO, "[" + scriptName + "] Unregistered command: " + dynamicCommand.getName(), "\u001b[38;5;49m");
                        this.invokeSyncCommands();
                        continue;
                    }
                    this.pluginLogger.log(Level.INFO, "[" + scriptName + "] Failed to unregister command: " + dynamicCommand.getName(), "\u001b[38;5;49m");
                }
            }
            catch (Exception e) {
                this.pluginLogger.log(Level.SEVERE, "Failed to unregister commands for script: " + scriptName + " " + e, "\u001b[38;5;214m");
                e.printStackTrace();
            }
        }
    }

    public void unregisterAllScriptCommands() {
        try {
            for (String scriptName : this.scriptCommands.keySet()) {
                this.unregisterCommands(scriptName);
            }
            this.scriptCommands.clear();
        }
        catch (Exception e) {
            this.pluginLogger.log(Level.SEVERE, "Failed to unregister all script commands.", e.getMessage());
        }
    }

    public void saveDisabledScripts() {
        try (FileWriter writer = new FileWriter(this.disabledScriptsFile);){
            JSONArray jsonArray = new JSONArray();
            jsonArray.addAll(this.disabledScripts);
            writer.write(jsonArray.toJSONString());
        }
        catch (IOException e) {
            this.pluginLogger.log(Level.SEVERE, "Failed to save disabled scripts." + e.getMessage(), "\u001b[31m");
        }
    }

    public void checkDisabledScripts() {
        File scriptsFolder = new File(this.plugin.getDataFolder(), "scripts");
        ArrayList<String> scriptsInFolder = new ArrayList<String>();
        if (scriptsFolder.exists() && scriptsFolder.isDirectory()) {
            for (File scriptFile : Objects.requireNonNull(scriptsFolder.listFiles())) {
                if (!scriptFile.isFile() || !scriptFile.getName().endsWith(".js")) continue;
                scriptsInFolder.add(scriptFile.getName());
            }
        }
        boolean modified = false;
        Iterator<String> iterator = this.disabledScripts.iterator();
        while (iterator.hasNext()) {
            String scriptName = iterator.next();
            if (scriptsInFolder.contains(scriptName)) continue;
            iterator.remove();
            modified = true;
            this.pluginLogger.log(Level.INFO, "Removed non-existent script " + scriptName + " from disabled scripts list.", "\u001b[34m");
        }
        if (modified) {
            this.saveDisabledScripts();
        }
    }

    public void unloadScript(String scriptName) {
        if (!this.runningScripts.contains(scriptName)) {
            return;
        }
        this.unregisterListenersFromScript(scriptName);
        this.unregisterCommands(scriptName);
        this.unregisterTasksFromScript(scriptName);
        Future<?> future = this.scriptFutures.remove(scriptName);
        if (future != null) {
            future.cancel(true);
        }
        javax.script.ScriptEngine engine = this.scriptEngines.remove(scriptName);
        this.runningScripts.remove(scriptName);
        if (engine != null) {
            engine.getBindings(100).clear();
        }
        if (this.plugin.isEnabled()) {
            FoliaSupport.runTaskSynchronously(this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent((Event)new ScriptUnloadedEvent(scriptName)));
        }
    }

    public String preprocessScript(File scriptFile, javax.script.ScriptEngine scriptEngine) throws IOException {
        if (!this.configUtil.getConfigFromBuffer("UseCustomInterpreter", true).booleanValue()) {
            return new String(Files.readAllBytes(scriptFile.toPath()));
        }
        StringBuilder scriptContent = new StringBuilder();
        ArrayList<String> imports = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(scriptFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("//!import ")) {
                    String importLine = line.substring(9).trim();
                    imports.add(importLine);
                    continue;
                }
                scriptContent.append(line).append("\n");
            }
        }
        StringBuilder finalScript = new StringBuilder();
        for (String importStatement : imports) {
            try {
                Class<?> clazz = Class.forName(importStatement);
                String simpleName = clazz.getSimpleName();
                scriptEngine.put(simpleName, clazz);
            }
            catch (ClassNotFoundException e) {
                this.pluginLogger.log(Level.WARNING, "Class not found for import: " + importStatement, "\u001b[38;5;214m");
            }
        }
        finalScript.append((CharSequence)scriptContent);
        return finalScript.toString();
    }

    public List<String> getNotLoadedScripts() {
        File scriptsFolder = new File(this.plugin.getDataFolder(), "scripts");
        ArrayList<String> notLoadedScripts = new ArrayList<String>();
        if (scriptsFolder.exists() && scriptsFolder.isDirectory()) {
            for (File scriptFile : Objects.requireNonNull(scriptsFolder.listFiles())) {
                if (!scriptFile.isFile() || !scriptFile.getName().endsWith(".js") || this.activeFiles.contains(scriptFile.getName()) || this.disabledScripts.contains(scriptFile.getName())) continue;
                notLoadedScripts.add(scriptFile.getName());
            }
        }
        return notLoadedScripts;
    }

    public ScriptLoadResult loadScript(File scriptFile, boolean calledFromScript) {
        if (scriptFile.isFile() && scriptFile.getName().endsWith(".js") && !this.disabledScripts.contains(scriptFile.getName())) {
            if (calledFromScript) {
                if (!this.hasInit || !this.scriptsReady) {
                    return new ScriptLoadResult(false, "Do not manually load scripts while they are being initialized!");
                }
            } else if (this.configUtil.getConfigFromBuffer("AllowFeatureFlags", true).booleanValue() && FlagInterpreter.hasFlag(scriptFile, "loadManually")) {
                return new ScriptLoadResult(false, "Script file will only load manually");
            }
            this.unloadScript(scriptFile.getName());
            javax.script.ScriptEngine localScriptEngine = ScriptEngine.getEngine();
            this.scriptEngines.put(scriptFile.getName(), localScriptEngine);
            localScriptEngine.put("plugin", this.plugin);
            localScriptEngine.put("scriptManager", this);
            localScriptEngine.put("scriptEngine", localScriptEngine);
            localScriptEngine.put("currentScriptName", scriptFile.getName());
            localScriptEngine.put("log", new ScriptLogger(Bukkit.getLogger(), scriptFile.getName()));
            localScriptEngine.put("variableStorage", this.variableStorage);
            localScriptEngine.put("publicVarManager", this.PublicVarManager);
            localScriptEngine.put("waitForScript", this::waitForScript);
            Future<?> future = this.executorService.submit(() -> {
                try {
                    if (this.configUtil.getConfigFromBuffer("AllowFeatureFlags", true).booleanValue() && FlagInterpreter.hasFlag(scriptFile, "waitForInit")) {
                        localScriptEngine.eval("scriptManager.waitForInit()");
                    }
                    localScriptEngine.eval("function toArray(args) {    return Array.prototype.slice.call(args)}function toJavaList(data) {    return Java.to(data, 'java.util.List');}function addCommand(commandName, commandHandler, tabCompleter) {    scriptManager.registerCommand(commandName, commandHandler, currentScriptName, scriptEngine);}function LoadScript(scriptName) {     var result = scriptManager.loadScript(new java.io.File(plugin.getDataFolder() + '/scripts/' + scriptName), true);     var success = result.isSuccess();     var err = result.getMessage();     if (!success) {         log.error(err);     } }function UnloadScript(scriptName) {    scriptManager.unloadScript(scriptName);}function setShared(key, value) {    publicVarManager.setPublicVar(key, value);}function getShared(key) {    try {        return publicVarManager.getPublicVar(key);    } catch (e) {        log.warn('Failed to get public variable: ' + e.message);        return null;    }}function loadVar(varName, defaultVar, global) {    return JSON.parse(variableStorage.getStoredVar(currentScriptName, varName, defaultVar, global));}function saveVar(varName, variable, global) {    variableStorage.setStoredVar(currentScriptName, varName, JSON.stringify(variable), global);}");
                    if (this.configUtil.getConfigFromBuffer("LoadCustomEventsHandler", true).booleanValue()) {
                        localScriptEngine.eval("function registerEvent(eventClass, handler) {    scriptManager.registerEvent(eventClass, handler, currentScriptName, scriptEngine);}");
                    }
                    if (this.configUtil.getConfigFromBuffer("LoadCustomScheduler", true).booleanValue()) {
                        localScriptEngine.eval("function registerSchedule(delay, period, handler, method) {    scriptManager.registerSchedule(delay, period, handler, scriptEngine, method, currentScriptName);}");
                    }
                    String processedScript = this.preprocessScript(scriptFile, localScriptEngine);
                    localScriptEngine.eval(processedScript);
                    if (this.configUtil.getConfigFromBuffer("PrintScriptActivations", true).booleanValue()) {
                        this.pluginLogger.log(Level.INFO, "Loaded the script " + scriptFile.getName(), "\u001b[38;5;49m");
                    }
                    FoliaSupport.runTaskSynchronously(this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent((Event)new ScriptLoadedEvent(scriptFile.getName())));
                }
                catch (IOException | ScriptException e) {
                    this.pluginLogger.log(Level.WARNING, "Failed to load script " + scriptFile.getName() + ". " + e.getMessage(), "\u001b[38;5;214m");
                }
            });
            if (!this.activeFiles.contains(scriptFile.getName())) {
                this.activeFiles.add(scriptFile.getName());
            }
            if (!this.runningScripts.contains(scriptFile.getName())) {
                this.runningScripts.add(scriptFile.getName());
            }
            this.scriptFutures.put(scriptFile.getName(), future);
            return new ScriptLoadResult(true, "Script loaded successfully.");
        }
        return new ScriptLoadResult(false, "Invalid script file.");
    }

    public void loadScripts() {
        File scriptsFolder = new File(this.plugin.getDataFolder(), "scripts");
        this.unloadAllScripts();
        if (scriptsFolder.exists() && scriptsFolder.isDirectory()) {
            ArrayList<Future<ScriptLoadResult>> futures = new ArrayList<Future<ScriptLoadResult>>();
            for (File scriptFile : Objects.requireNonNull(scriptsFolder.listFiles())) {
                Future<ScriptLoadResult> future = this.executorService.submit(() -> this.loadScript(scriptFile, false));
                futures.add(future);
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    this.pluginLogger.log(Level.WARNING, "An error occurred while waiting for script loading tasks to complete: " + e.getMessage(), "\u001b[38;5;214m");
                }
            }
        }
    }

    public void registerCommand(final String commandName, final Object commandHandler, final String scriptName, final javax.script.ScriptEngine scriptEngine) {
        try {
            CommandMap commandMap = this.getCommandMap();
            Command dynamicCommand = new Command(commandName){

                public boolean execute(@NotNull CommandSender sender, @NotNull String label, String[] args) {
                    try {
                        ((Invocable)((Object)scriptEngine)).invokeMethod(commandHandler, "onCommand", sender, args);
                    }
                    catch (Exception e) {
                        sender.sendMessage("\u00a7cAn error occurred while executing the command: " + e.getMessage());
                        scriptWrapper.this.pluginLogger.log(Level.SEVERE, "Error in script command execution for " + commandName + e.getMessage(), "\u001b[38;5;214m");
                    }
                    return true;
                }

                @NotNull
                public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
                    if (commandHandler instanceof Bindings && ((Bindings)commandHandler).containsKey("onTabComplete")) {
                        try {
                            return (List)((Invocable)((Object)scriptEngine)).invokeMethod(commandHandler, "onTabComplete", sender, args);
                        }
                        catch (Exception e) {
                            scriptWrapper.this.pluginLogger.log(Level.WARNING, "[" + scriptName + "] Error during tab-completion for command " + commandName + e.getMessage(), "\u001b[38;5;214m");
                        }
                    }
                    return super.tabComplete(sender, alias, args);
                }
            };
            commandMap.register(this.plugin.getDescription().getName(), dynamicCommand);
            this.scriptCommands.computeIfAbsent(scriptName, k -> new ArrayList()).add(dynamicCommand);
            this.pluginLogger.log(Level.INFO, "[" + scriptName + "] Registered command: " + commandName, "\u001b[38;5;49m");
        }
        catch (Exception e) {
            this.pluginLogger.log(Level.SEVERE, "[" + scriptName + "] Failed to register command " + commandName, e.getMessage());
        }
    }

    public void waitForScript(String scriptName) {
        while (!this.isJavascriptFileRunning(scriptName)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public void waitForInit() {
        while (!this.scriptsReady) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public void registerSchedule(String scriptName, long delay, long period, Object handler, javax.script.ScriptEngine scriptEngine, String methodName) {
        Runnable task = () -> {
            try {
                ((Invocable)((Object)scriptEngine)).invokeMethod(handler, methodName, new Object[0]);
            }
            catch (NoSuchMethodException | ScriptException e) {
                this.pluginLogger.log(Level.SEVERE, "[" + scriptName + "] " + e.getMessage(), "\u001b[31m");
            }
        };
        int taskId = period > 0L ? FoliaSupport.ScheduleRepeatingTask(this.plugin, task, delay, period) : FoliaSupport.ScheduleTask(this.plugin, task, delay);
        this.scriptTasksMap.computeIfAbsent(scriptName, k -> new ArrayList()).add(taskId);
    }

    public void registerEvent(String eventClassName, Object handler, String scriptName, javax.script.ScriptEngine scriptEngine) {
        try {
            Class<?> eventClass = Class.forName(eventClassName);
            if (Event.class.isAssignableFrom(eventClass)) {
                Class<?> eventClassCasted = eventClass;
                EventListenerWrapper listener = new EventListenerWrapper(scriptEngine, handler, (Plugin)this.plugin);
                Bukkit.getServer().getPluginManager().registerEvent(eventClassCasted, (Listener)listener, EventPriority.NORMAL, (l, e) -> {
                    try {
                        ((Invocable)((Object)scriptEngine)).invokeMethod(handler, "handleEvent", e);
                    }
                    catch (NoSuchMethodException | ScriptException ex) {
                        this.pluginLogger.log(Level.SEVERE, "[" + scriptName + "] " + ex.getMessage(), "\u001b[31m");
                    }
                }, (Plugin)this.plugin);
                this.eventListenersMap.computeIfAbsent(scriptName, k -> new ArrayList()).add(listener);
            } else {
                this.pluginLogger.log(Level.WARNING, "Class " + eventClassName + " is not an Event.", "\u001b[38;5;214m");
            }
        }
        catch (ClassNotFoundException e2) {
            this.pluginLogger.log(Level.WARNING, "Failed to register event " + eventClassName + ": " + e2.getMessage(), "\u001b[38;5;214m");
        }
    }

    public static class ScriptLoadResult {
        private final boolean success;
        private final String message;

        public ScriptLoadResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

