/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs.modules;

import coolcostupit.openjs.foliascheduler.FoliaCompatibility;
import coolcostupit.openjs.foliascheduler.ServerImplementation;
import coolcostupit.openjs.foliascheduler.folia.FoliaTask;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class FoliaSupport {
    private static Boolean cached = null;
    private static Boolean isFoliaChecked = null;
    private static final Map<Integer, Object> activeTasks = new HashMap<Integer, Object>();
    private static int nextTaskId = 1;

    public static boolean isFolia() {
        if (cached == null) {
            if (isFoliaChecked == null) {
                boolean foliaDetected = false;
                try {
                    Method getRegionScheduler = Bukkit.getServer().getClass().getMethod("getRegionScheduler", new Class[0]);
                    foliaDetected = getRegionScheduler != null;
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
                isFoliaChecked = foliaDetected;
            }
            cached = true;
        }
        return isFoliaChecked;
    }

    public static int ScheduleTask(JavaPlugin plugin, Runnable function, long delay) {
        Object task;
        if (FoliaSupport.isFolia()) {
            ServerImplementation scheduler = new FoliaCompatibility((Plugin)plugin).getServerImplementation();
            task = scheduler.async().runDelayed(function, delay);
        } else {
            task = Bukkit.getScheduler().runTaskLater((Plugin)plugin, function, delay);
        }
        return FoliaSupport.addTask(task);
    }

    public static int runTask(JavaPlugin plugin, Runnable function) {
        Object task;
        if (FoliaSupport.isFolia()) {
            ServerImplementation scheduler = new FoliaCompatibility((Plugin)plugin).getServerImplementation();
            task = scheduler.async().runNow(function);
        } else {
            task = Bukkit.getScheduler().runTask((Plugin)plugin, function);
        }
        return FoliaSupport.addTask(task);
    }

    public static int runTaskSynchronously(JavaPlugin plugin, Runnable function) {
        Object task;
        if (FoliaSupport.isFolia()) {
            ServerImplementation scheduler = new FoliaCompatibility((Plugin)plugin).getServerImplementation();
            task = scheduler.global().run(function);
        } else {
            task = Bukkit.getScheduler().runTask((Plugin)plugin, function);
        }
        return FoliaSupport.addTask(task);
    }

    public static int ScheduleRepeatingTask(JavaPlugin plugin, Runnable function, long delay, long period) {
        Object task;
        if (FoliaSupport.isFolia()) {
            ServerImplementation scheduler = new FoliaCompatibility((Plugin)plugin).getServerImplementation();
            task = scheduler.async().runAtFixedRate(function, delay, period);
        } else {
            task = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, function, delay, period);
        }
        return FoliaSupport.addTask(task);
    }

    public static boolean CancelTask(int taskId) {
        Object task = activeTasks.remove(taskId);
        if (task == null) {
            return false;
        }
        try {
            if (FoliaSupport.isFolia()) {
                ((FoliaTask)task).cancel();
            } else {
                ((BukkitTask)task).cancel();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int addTask(Object task) {
        Integer taskId = nextTaskId++;
        activeTasks.put(taskId, task);
        return taskId;
    }
}

