/*
 * Decompiled with CFR 0.152.
 */
package coolcostupit.openjs;

import coolcostupit.openjs.logging.OpsLogger;
import coolcostupit.openjs.logging.pluginLogger;
import coolcostupit.openjs.modules.FoliaSupport;
import coolcostupit.openjs.modules.ScriptEngine;
import coolcostupit.openjs.modules.scriptWrapper;
import coolcostupit.openjs.utility.Metrics;
import coolcostupit.openjs.utility.UpdateChecker;
import coolcostupit.openjs.utility.VariableStorage;
import coolcostupit.openjs.utility.configurationUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class OpenJSPlugin
extends JavaPlugin
implements TabExecutor,
TabCompleter,
Listener {
    public configurationUtil configUtil;
    private pluginLogger pluginLogger;
    private VariableStorage variableStorage;
    private scriptWrapper scriptWrapper;
    private UpdateChecker updateChecker;

    public void onEnable() {
        Metrics metrics = new Metrics(this, 22268);
        Server server = this.getServer();
        PluginManager pluginManager = server.getPluginManager();
        this.configUtil = new configurationUtil(this);
        this.pluginLogger = new pluginLogger(this, this.configUtil);
        this.variableStorage = new VariableStorage(this);
        if (ScriptEngine.getEngine() == null) {
            this.pluginLogger.log(Level.SEVERE, "Failed to initialize JavaScript engine. Disabling plugin.", "\u001b[31m");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.scriptWrapper = new scriptWrapper(this, this.configUtil);
        this.updateChecker = new UpdateChecker(this, this.pluginLogger, this.configUtil);
        this.updateChecker.startChecking();
        this.scriptWrapper.loadDisabledScripts();
        this.scriptWrapper.checkDisabledScripts();
        this.saveDefaultConfig();
        this.configUtil.loadBufferFromConfig();
        this.scriptWrapper.loadScripts();
        this.configUtil.getConfigFromBuffer("PrintScriptActivations", true);
        this.configUtil.getConfigFromBuffer("UseCustomInterpreter", true);
        this.configUtil.getConfigFromBuffer("LoadCustomEventsHandler", true);
        this.configUtil.getConfigFromBuffer("LoadCustomScheduler", true);
        this.configUtil.getConfigFromBuffer("UpdateNotifications", true);
        this.configUtil.getConfigFromBuffer("AllowFeatureFlags", true);
        this.configUtil.getConfigFromBuffer("BroadcastToOps", true);
        this.configUtil.saveBufferToConfig();
        this.getCommand("oj").setExecutor((CommandExecutor)this);
        this.getCommand("oj").setTabCompleter((TabCompleter)this);
        this.getCommand("openjavascript").setExecutor((CommandExecutor)this);
        this.getCommand("openjavascript").setTabCompleter((TabCompleter)this);
        pluginManager.registerEvents((Listener)this, (Plugin)this);
        this.pluginLogger.log(Level.INFO, "[<------------------------------->]", "\u001b[34m");
        this.pluginLogger.log(Level.INFO, "      [OpenJavascript enabled]", "\u001b[38;5;81m");
        this.pluginLogger.log(Level.INFO, "Version: " + this.getDescription().getVersion(), "\u001b[38;5;81m");
        this.pluginLogger.log(Level.INFO, "Author: " + this.getDescription().getAuthors().toString().substring(1, this.getDescription().getAuthors().toString().length() - 1), "\u001b[38;5;81m");
        this.pluginLogger.log(Level.INFO, "Java Version: " + System.getProperty("java.version"), "\u001b[38;5;81m");
        if (FoliaSupport.isFolia()) {
            this.pluginLogger.log(Level.INFO, "Folia Support: true (BETA)", "\u001b[38;5;214m");
        }
        this.pluginLogger.log(Level.INFO, "[<------------------------------->]", "\u001b[34m");
    }

    public void onDisable() {
        this.pluginLogger.log(Level.INFO, "[<---------------------------------->]", "\u001b[34m");
        this.pluginLogger.log(Level.INFO, "      [OpenJavascript shutdown]", "\u001b[38;5;81m");
        this.pluginLogger.log(Level.INFO, "Un-registering all listeners...", "\u001b[38;5;81m");
        this.scriptWrapper.unregisterAllListeners();
        this.pluginLogger.log(Level.INFO, "Un-registering all tasks...", "\u001b[38;5;81m");
        this.scriptWrapper.unregisterAllTasks();
        this.pluginLogger.log(Level.INFO, "Un-registering all script commands...", "\u001b[38;5;81m");
        this.scriptWrapper.unregisterAllScriptCommands();
        this.pluginLogger.log(Level.INFO, "Un-loading all scripts...", "\u001b[38;5;81m");
        this.scriptWrapper.executorService.shutdown();
        this.scriptWrapper.unloadAllScripts();
        this.pluginLogger.log(Level.INFO, "Storing memory variables...", "\u001b[38;5;81m");
        this.variableStorage.saveVariables();
        this.pluginLogger.log(Level.INFO, "[OpenJavascript shutdown successfully]", "\u001b[38;5;81m");
        this.pluginLogger.log(Level.INFO, "[<---------------------------------->]", "\u001b[34m");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.configUtil.getConfigFromBuffer("UpdateNotifications", true).booleanValue() && this.updateChecker.UpdatesAvailable() && OpsLogger.hasPerm(player)) {
            player.sendMessage("\u00a77-----------------------------------------------------");
            player.sendMessage("\u00a76A new version of OpenJS is available!");
            player.sendMessage("\u00a76Current version: \u00a7c" + this.updateChecker.CurrentVersion);
            player.sendMessage("\u00a76Latest version: \u00a7a" + this.updateChecker.LatestVersion);
            player.sendMessage("\u00a76Download it here: \u00a79https://www.spigotmc.org/resources/117328/");
            player.sendMessage("\u00a77-----------------------------------------------------");
        }
    }

    private void list_enabled_scripts(CommandSender sender) {
        sender.sendMessage("\u00a7aEnabled scripts:");
        if (this.scriptWrapper.activeFiles.isEmpty()) {
            sender.sendMessage("\u00a7a- There are no enabled scripts.");
        } else {
            for (String script : this.scriptWrapper.activeFiles) {
                sender.sendMessage("\u00a7a- " + script);
            }
        }
    }

    private void list_disabled_scripts(CommandSender sender) {
        sender.sendMessage("\u00a7cDisabled scripts:");
        if (this.scriptWrapper.disabledScripts.isEmpty()) {
            sender.sendMessage("\u00a7c- There are no disabled scripts.");
        } else {
            for (String script : this.scriptWrapper.disabledScripts) {
                sender.sendMessage("\u00a7c- " + script);
            }
        }
    }

    private void list_unloaded_scripts(CommandSender sender) {
        sender.sendMessage("\u00a74Scripts that are not loaded yet:");
        List<String> notLoadedScripts = this.scriptWrapper.getNotLoadedScripts();
        if (notLoadedScripts.isEmpty()) {
            sender.sendMessage("\u00a74- There are no scripts that haven't been loaded yet.");
        } else {
            for (String script : notLoadedScripts) {
                sender.sendMessage("\u00a74- " + script);
            }
        }
    }

    private void sendUsageMessage(CommandSender sender, String label) {
        sender.sendMessage("\u00a7dUsage: /" + label + " <command>");
        sender.sendMessage("\u00a7d/" + label + " version <-- will output the version of this plugin");
        sender.sendMessage("\u00a7d/" + label + " reload <script>(optional) <-- will reload the script");
        sender.sendMessage("\u00a7d/" + label + " load <script> <-- will load the script");
        sender.sendMessage("\u00a7d/" + label + " enable <disabled_script> <-- will enable the disabled script");
        sender.sendMessage("\u00a7d/" + label + " disable <enabled_script> <-- will disable the enabled script");
        sender.sendMessage("\u00a7d/" + label + " list *(enabled/disabled/not_loaded) <-- will list the specified parameter");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendUsageMessage(sender, label);
            return true;
        }
        if ("help".equalsIgnoreCase(args[0])) {
            this.sendUsageMessage(sender, label);
            return true;
        }
        if ("version".equalsIgnoreCase(args[0])) {
            sender.sendMessage("\u00a79Version: " + this.getDescription().getVersion());
            return true;
        }
        if (args.length == 1 && "list".equalsIgnoreCase(args[0])) {
            this.list_enabled_scripts(sender);
            this.list_disabled_scripts(sender);
            this.list_unloaded_scripts(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                if (args.length < 2) {
                    this.configUtil.reloadConfigBuffer();
                    this.scriptWrapper.loadScripts();
                    sender.sendMessage("\u00a7aAll scripts and the config have been reloaded.");
                    return true;
                }
                String scriptToReload = args[1];
                if (this.scriptWrapper.isJavascriptFileActive(scriptToReload)) {
                    File scriptFile = new File(this.getDataFolder(), "scripts/" + scriptToReload);
                    if (scriptFile.exists()) {
                        this.scriptWrapper.loadScript(scriptFile, true);
                        sender.sendMessage("\u00a7aScript " + scriptToReload + " has been reloaded.");
                        return true;
                    }
                    sender.sendMessage("\u00a7cCan't reload " + scriptToReload + " because it does not exist.");
                } else {
                    sender.sendMessage("\u00a7cCan't reload " + scriptToReload + " because it is not enabled.");
                }
                return true;
            }
            case "enable": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7dUsage: /" + label + " " + subCommand + " <scriptName>");
                    return true;
                }
                String scriptToEnable = args[1];
                if (this.scriptWrapper.disabledScripts.contains(scriptToEnable)) {
                    this.scriptWrapper.disabledScripts.remove(scriptToEnable);
                    this.scriptWrapper.saveDisabledScripts();
                    File scriptFile = new File(this.getDataFolder(), "scripts/" + scriptToEnable);
                    if (scriptFile.exists()) {
                        this.scriptWrapper.loadScript(scriptFile, true);
                        sender.sendMessage("\u00a7aScript " + scriptToEnable + " enabled.");
                        return true;
                    }
                    sender.sendMessage("\u00a7cScript " + scriptToEnable + " not found.");
                } else {
                    sender.sendMessage("\u00a7cScript " + scriptToEnable + " is not disabled.");
                }
                return true;
            }
            case "disable": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7dUsage: /" + label + " " + subCommand + " <scriptName>");
                    return true;
                }
                String scriptToDisable = args[1];
                if (this.scriptWrapper.isJavascriptFileActive(scriptToDisable)) {
                    this.scriptWrapper.activeFiles.remove(scriptToDisable);
                    this.scriptWrapper.disabledScripts.add(scriptToDisable);
                    this.scriptWrapper.unloadScript(scriptToDisable);
                    this.scriptWrapper.saveDisabledScripts();
                    sender.sendMessage("\u00a7cScript " + scriptToDisable + " disabled.");
                    return true;
                }
                sender.sendMessage("\u00a7cScript " + scriptToDisable + " is not active.");
                return true;
            }
            case "load": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7dUsage: /" + label + " " + subCommand + " <scriptName>");
                    return true;
                }
                String scriptToLoad = args[1];
                if (this.scriptWrapper.disabledScripts.contains(scriptToLoad)) {
                    sender.sendMessage("\u00a7cUnable to load a disabled script. Use command /" + label + " enable " + scriptToLoad + " to load it.");
                    return true;
                }
                File scriptFile = new File(this.getDataFolder(), "scripts/" + scriptToLoad);
                if (scriptFile.exists()) {
                    this.scriptWrapper.loadScript(scriptFile, true);
                    sender.sendMessage("\u00a7aScript " + scriptToLoad + " loaded.");
                    return true;
                }
                sender.sendMessage("\u00a7cScript " + scriptToLoad + " not found.");
                return true;
            }
            case "list": {
                String commandToExecute = args[1];
                if (commandToExecute.equalsIgnoreCase("enabled")) {
                    this.list_enabled_scripts(sender);
                } else if (commandToExecute.equalsIgnoreCase("disabled")) {
                    this.list_disabled_scripts(sender);
                } else if (commandToExecute.equalsIgnoreCase("not_loaded")) {
                    this.list_unloaded_scripts(sender);
                } else {
                    sender.sendMessage("\u00a7cUsage /" + label + " list *(enabled/disabled/not_loaded)");
                }
                return true;
            }
        }
        sender.sendMessage("\u00a7cUnknown command.");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block20: {
            block19: {
                completions = new ArrayList<String>();
                if (args.length != 1) break block19;
                if ("reload".startsWith(args[0].toLowerCase())) {
                    completions.add("reload");
                }
                if ("enable".startsWith(args[0].toLowerCase())) {
                    completions.add("enable");
                }
                if ("disable".startsWith(args[0].toLowerCase())) {
                    completions.add("disable");
                }
                if ("load".startsWith(args[0].toLowerCase())) {
                    completions.add("load");
                }
                if ("help".startsWith(args[0].toLowerCase())) {
                    completions.add("help");
                }
                if (!"list".startsWith(args[0].toLowerCase())) break block20;
                completions.add("list");
                break block20;
            }
            if (args.length == 2) {
                File scriptsFolder;
                if (args[0].equalsIgnoreCase("enable")) {
                    for (String script : this.scriptWrapper.disabledScripts) {
                        if (!script.startsWith(args[1].toLowerCase())) continue;
                        completions.add(script);
                    }
                } else if (args[0].equalsIgnoreCase("disable")) {
                    for (String script : this.scriptWrapper.activeFiles) {
                        if (!script.startsWith(args[1].toLowerCase())) continue;
                        completions.add(script);
                    }
                } else if (args[0].equalsIgnoreCase("reload")) {
                    for (String script : this.scriptWrapper.activeFiles) {
                        if (!script.startsWith(args[1].toLowerCase())) continue;
                        completions.add(script);
                    }
                } else if (args[0].equalsIgnoreCase("list")) {
                    completions.add("enabled");
                    completions.add("disabled");
                    completions.add("not_loaded");
                } else if (args[0].equalsIgnoreCase("load") && (scriptsFolder = new File(this.getDataFolder(), "scripts")).exists() && scriptsFolder.isDirectory()) {
                    for (File scriptFile : Objects.requireNonNull(scriptsFolder.listFiles())) {
                        if (!scriptFile.isFile() || !scriptFile.getName().endsWith(".js") || this.scriptWrapper.activeFiles.contains(scriptFile.getName()) || this.scriptWrapper.disabledScripts.contains(scriptFile.getName()) || !scriptFile.getName().startsWith(args[1].toLowerCase())) continue;
                        completions.add(scriptFile.getName());
                    }
                }
            }
        }
        return completions;
    }
}

