/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.geysermc;

import com.starshootercity.OrbOfOrigin;
import com.starshootercity.Origin;
import com.starshootercity.OriginLoader;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.events.PlayerSwapOriginEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.ItemMeta;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.ModalForm;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.geyser.api.GeyserApi;
import org.geysermc.geyser.api.connection.GeyserConnection;

public class GeyserSwapper {
    private static final Random random = new Random();

    public static boolean checkBedrockSwap(Player player, PlayerSwapOriginEvent.SwapReason reason, boolean cost, boolean displayOnly) {
        try {
            if (!GeyserApi.api().isBedrockPlayer(player.getUniqueId())) {
                return true;
            }
            GeyserSwapper.openOriginSwapper(player, reason, displayOnly, cost);
            return false;
        }
        catch (NoClassDefFoundError e) {
            return true;
        }
    }

    public static void openOriginSwapper(Player player, PlayerSwapOriginEvent.SwapReason reason, boolean displayOnly, boolean cost) {
        ArrayList<Origin> origins = new ArrayList<Origin>(OriginLoader.origins);
        if (displayOnly) {
            GeyserSwapper.openOriginInfo(player, OriginSwapper.getOrigin(player), PlayerSwapOriginEvent.SwapReason.COMMAND, true, false);
            return;
        }
        origins.removeIf(Origin::isUnchoosable);
        origins.sort((o1, o2) -> {
            if (o1.getImpact() == o2.getImpact()) {
                if (o1.getPosition() == o2.getPosition()) {
                    return 0;
                }
                return o1.getPosition() > o2.getPosition() ? 1 : -1;
            }
            return o1.getImpact() > o2.getImpact() ? 1 : -1;
        });
        SimpleForm.Builder form = (SimpleForm.Builder)SimpleForm.builder().title("Choose your Origin");
        for (Origin origin : origins) {
            if (origin.getIcon().getType() == Material.PLAYER_HEAD) {
                form.button(origin.getName(), FormImage.Type.URL, "https://mc-heads.net/avatar/MHF_Steve");
                continue;
            }
            form.button(origin.getName(), FormImage.Type.URL, origin.getResourceURL());
        }
        form.button("Random", FormImage.Type.URL, "https://static.wikia.nocookie.net/origins-smp/images/1/13/Origin_Orb.png/revision/latest?cb=20210411202749");
        GeyserSwapper.sendForm(player.getUniqueId(), ((SimpleForm.Builder)((SimpleForm.Builder)form.closedOrInvalidResultHandler(() -> {
            if (OriginSwapper.getOrigin(player) == null) {
                GeyserSwapper.openOriginSwapper(player, reason, false, cost);
            }
        })).validResultHandler(response -> GeyserSwapper.openOriginInfo(player, OriginLoader.originNameMap.get(response.clickedButton().text().toLowerCase()), reason, false, cost))).build());
    }

    private static void sendForm(UUID uuid, Form form) {
        try {
            FloodgateApi.getInstance().sendForm(uuid, form);
        }
        catch (NoClassDefFoundError e) {
            GeyserApi.api().sendForm(uuid, form);
        }
    }

    public static void setOrigin(Player player, Origin origin, PlayerSwapOriginEvent.SwapReason reason, boolean cost) {
        if (OriginsReborn.getInstance().isVaultEnabled() && cost) {
            int amount = OriginsReborn.getInstance().getConfig().getInt("swap-command.vault.cost", 1000);
            Economy economy = OriginsReborn.getInstance().getEconomy();
            if (economy.has((OfflinePlayer)player, (double)amount)) {
                economy.withdrawPlayer((OfflinePlayer)player, (double)amount);
            } else {
                String symbol = OriginsReborn.getInstance().getConfig().getString("swap-command.vault.currency-symbol", "$");
                player.sendMessage((Component)Component.text((String)"You need %s%s to swap your origin!".formatted(symbol, amount)));
                return;
            }
        }
        ItemMeta meta = player.getInventory().getItemInMainHand().getItemMeta();
        if (reason == PlayerSwapOriginEvent.SwapReason.ORB_OF_ORIGIN) {
            ItemMeta offhandMeta;
            EquipmentSlot hand = null;
            if (meta != null && meta.getPersistentDataContainer().has(OrbOfOrigin.orbKey)) {
                hand = EquipmentSlot.HAND;
            }
            if (hand == null && (offhandMeta = player.getInventory().getItemInOffHand().getItemMeta()) != null && offhandMeta.getPersistentDataContainer().has(OrbOfOrigin.orbKey)) {
                hand = EquipmentSlot.OFF_HAND;
            }
            if (hand == null) {
                return;
            }
            OriginSwapper.orbCooldown.put(player, System.currentTimeMillis());
            player.swingHand(hand);
            if (OriginsReborn.getInstance().getConfig().getBoolean("orb-of-origin.consume")) {
                player.getInventory().getItem(hand).setAmount(player.getInventory().getItem(hand).getAmount() - 1);
            }
        }
        boolean resetPlayer = OriginSwapper.shouldResetPlayer(reason);
        if (origin == null) {
            ArrayList<Origin> origins = new ArrayList<Origin>(OriginLoader.origins);
            origins.removeIf(Origin::isUnchoosable);
            List excludedOrigins = OriginsReborn.getInstance().getConfig().getStringList("origin-selection.random-option.exclude");
            origins.removeIf(possibleOrigin -> excludedOrigins.contains(possibleOrigin.getName()));
            origin = (Origin)origins.get(random.nextInt(origins.size()));
        }
        OriginSwapper.setOrigin(player, origin, reason, resetPlayer);
    }

    public static void openOriginInfo(Player player, Origin origin, PlayerSwapOriginEvent.SwapReason reason, boolean displayOnly, boolean cost) {
        GeyserConnection geyserPlayer = GeyserApi.api().connectionByUuid(player.getUniqueId());
        if (geyserPlayer == null) {
            return;
        }
        ModalForm.Builder form = ModalForm.builder();
        StringBuilder info = new StringBuilder();
        if (origin != null) {
            form.title(origin.getName());
            for (OriginSwapper.LineData.LineComponent line : new OriginSwapper.LineData(origin).getRawLines()) {
                if (line.isEmpty()) {
                    info.append("\n\n");
                } else {
                    info.append(line.getRawText());
                }
                if (line.getType() != OriginSwapper.LineData.LineComponent.LineType.TITLE) continue;
                info.append("\n");
            }
        } else {
            form.title("Random Origin");
            ArrayList<Origin> origins = new ArrayList<Origin>(OriginLoader.origins);
            origins.removeIf(Origin::isUnchoosable);
            List excludedOrigins = OriginsReborn.getInstance().getConfig().getStringList("origin-selection.random-option.exclude");
            info.append("You'll be assigned one of the following:\n\n");
            for (Origin possibleOrigin : origins) {
                if (excludedOrigins.contains(possibleOrigin.getName())) continue;
                info.append(possibleOrigin.getName()).append("\n");
            }
        }
        if (cost) {
            String symbol = OriginsReborn.getInstance().getConfig().getString("swap-command.vault.currency-symbol", "$");
            int amount = OriginsReborn.getInstance().getConfig().getInt("swap-command.vault.cost", 1000);
            info.append("\n\n\n\u00a7eThis will cost you %s%s!".formatted(symbol, amount));
        }
        form.content(info.toString());
        form.button1("Cancel");
        form.button2("Confirm");
        GeyserSwapper.sendForm(player.getUniqueId(), ((ModalForm.Builder)((ModalForm.Builder)form.closedOrInvalidResultHandler(() -> {
            if (!displayOnly) {
                GeyserSwapper.openOriginInfo(player, origin, reason, false, cost);
            }
        })).validResultHandler(response -> {
            if (displayOnly) {
                return;
            }
            if (response.clickedButtonId() == 0) {
                GeyserSwapper.openOriginSwapper(player, reason, false, cost);
            } else {
                GeyserSwapper.setOrigin(player, origin, reason, cost);
            }
        })).build());
    }
}

