/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.events;

import com.starshootercity.Origin;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;

public class PlayerSwapOriginEvent
extends PlayerEvent
implements Cancellable {
    private boolean cancelled = false;
    private boolean resetPlayer;
    private final SwapReason reason;
    private final Origin oldOrigin;
    private Origin newOrigin;
    private static final HandlerList HANDLERS = new HandlerList();

    public PlayerSwapOriginEvent(@NotNull Player who, SwapReason reason, boolean resetPlayer, Origin oldOrigin, Origin newOrigin) {
        super(who);
        this.reason = reason;
        this.resetPlayer = resetPlayer;
        this.oldOrigin = oldOrigin;
        this.newOrigin = newOrigin;
    }

    public Origin getNewOrigin() {
        return this.newOrigin;
    }

    public Origin getOldOrigin() {
        return this.oldOrigin;
    }

    public void setNewOrigin(Origin newOrigin) {
        this.newOrigin = newOrigin;
    }

    public SwapReason getReason() {
        return this.reason;
    }

    public boolean isResetPlayer() {
        return this.resetPlayer;
    }

    public void setResetPlayer(boolean resetPlayer) {
        this.resetPlayer = resetPlayer;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    public static enum SwapReason {
        COMMAND("command"),
        ORB_OF_ORIGIN("orb"),
        DIED("died"),
        INITIAL("initial"),
        PLUGIN("plugin"),
        UNKNOWN("unknown");

        private final String reason;

        public String getReason() {
            return this.reason;
        }

        public static SwapReason get(String reason) {
            for (SwapReason swapReason : SwapReason.values()) {
                if (!swapReason.getReason().equals(reason)) continue;
                return swapReason;
            }
            return UNKNOWN;
        }

        private SwapReason(String reason) {
            this.reason = reason;
        }
    }
}

