/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.events;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerLeftClickEvent
extends PlayerEvent {
    private final PlayerInteractEvent playerInteractEvent;
    private static final HandlerList HANDLERS = new HandlerList();

    public PlayerLeftClickEvent(PlayerInteractEvent event) {
        super(event.getPlayer());
        this.playerInteractEvent = event;
    }

    @Nullable
    public Location getInteractionPoint() {
        return this.playerInteractEvent.getInteractionPoint();
    }

    public boolean hasBlock() {
        return this.playerInteractEvent.hasBlock();
    }

    public boolean hasItem() {
        return this.playerInteractEvent.hasItem();
    }

    @Nullable
    public ItemStack getItem() {
        return this.playerInteractEvent.getItem();
    }

    @NotNull
    public Material getMaterial() {
        return this.playerInteractEvent.getMaterial();
    }

    @Nullable
    public Block getClickedBlock() {
        return this.playerInteractEvent.getClickedBlock();
    }

    @Nullable
    public BlockFace getBlockFace() {
        return this.playerInteractEvent.getBlockFace();
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public static class PlayerLeftClickEventListener
    implements Listener {
        Map<Player, Integer> lastInteractionTickMap = new HashMap<Player, Integer>();

        @EventHandler
        public void onPlayerInteract(PlayerInteractEvent event) {
            if (event.getAction().isRightClick()) {
                return;
            }
            if (this.lastInteractionTickMap.getOrDefault(event.getPlayer(), -1) == Bukkit.getCurrentTick()) {
                return;
            }
            this.lastInteractionTickMap.put(event.getPlayer(), Bukkit.getCurrentTick());
            new PlayerLeftClickEvent(event).callEvent();
        }

        @EventHandler
        public void onPlayerDropItem(PlayerDropItemEvent event) {
            this.lastInteractionTickMap.put(event.getPlayer(), Bukkit.getCurrentTick());
        }

        @EventHandler
        public void onBlockBreak(BlockBreakEvent event) {
            this.lastInteractionTickMap.put(event.getPlayer(), Bukkit.getCurrentTick());
        }
    }
}

