/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.commands;

import com.starshootercity.OrbOfOrigin;
import com.starshootercity.Origin;
import com.starshootercity.OriginLoader;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.events.PlayerSwapOriginEvent;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OriginCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1) {
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "swap": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (OriginsReborn.getInstance().getConfig().getBoolean("swap-command.enabled")) {
                        if (player.hasPermission(OriginsReborn.getInstance().getConfig().getString("swap-command.permission", "originsreborn.admin"))) {
                            OriginSwapper.openOriginSwapper(player, PlayerSwapOriginEvent.SwapReason.COMMAND, 0, 0, OriginsReborn.getInstance().isVaultEnabled());
                        } else {
                            sender.sendMessage(Component.text((String)"You don't have permission to do this!").color((TextColor)NamedTextColor.RED));
                        }
                    } else {
                        sender.sendMessage(Component.text((String)"This command has been disabled in the configuration").color((TextColor)NamedTextColor.RED));
                    }
                } else {
                    sender.sendMessage(Component.text((String)"This command can only be run by a player").color((TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "reload": {
                Player player;
                if (sender instanceof Player && !(player = (Player)sender).hasPermission("originsreborn.admin")) {
                    sender.sendMessage(Component.text((String)"You don't have permission to do this!").color((TextColor)NamedTextColor.RED));
                    return true;
                }
                OriginLoader.reloadOrigins();
                OriginsReborn.getInstance().reloadConfig();
                return true;
            }
            case "set": {
                Player player;
                if (sender instanceof Player && !(player = (Player)sender).hasPermission("originsreborn.admin")) {
                    sender.sendMessage(Component.text((String)"You don't have permission to do this!").color((TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length < 3) {
                    return false;
                }
                player = Bukkit.getPlayer((String)args[1]);
                if (player == null) {
                    return false;
                }
                Origin origin = OriginLoader.originNameMap.get(args[2]);
                if (origin == null) {
                    return false;
                }
                OriginSwapper.setOrigin(player, origin, PlayerSwapOriginEvent.SwapReason.COMMAND, false);
                return true;
            }
            case "orb": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (player.hasPermission("originsreborn.admin")) {
                        player.getInventory().addItem(new ItemStack[]{OrbOfOrigin.orb});
                    } else {
                        sender.sendMessage(Component.text((String)"You don't have permission to do this!").color((TextColor)NamedTextColor.RED));
                    }
                } else {
                    sender.sendMessage(Component.text((String)"This command can only be run by a player").color((TextColor)NamedTextColor.RED));
                }
                return true;
            }
            case "check": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    OriginSwapper.openOriginSwapper(player, PlayerSwapOriginEvent.SwapReason.COMMAND, OriginLoader.origins.indexOf(OriginSwapper.getOrigin(player)), 0, false, true);
                } else {
                    sender.sendMessage(Component.text((String)"This command can only be run by a player").color((TextColor)NamedTextColor.RED));
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> data = switch (args.length) {
            case 1 -> {
                ArrayList<String> r = new ArrayList<String>();
                r.add("check");
                if (sender.hasPermission(OriginsReborn.getInstance().getConfig().getString("swap-command.permission", "originsreborn.admin"))) {
                    r.add("swap");
                }
                if (!sender.hasPermission("originsreborn.admin")) {
                    yield r;
                }
                r.add("reload");
                r.add("set");
                r.add("orb");
                yield r;
            }
            case 2 -> {
                if (args[0].equals("set")) {
                    yield new ArrayList<String>(){
                        {
                            for (Player player : Bukkit.getOnlinePlayers()) {
                                this.add(player.getName());
                            }
                        }
                    };
                }
                yield new ArrayList();
            }
            case 3 -> {
                if (args[0].equals("set")) {
                    yield new ArrayList<String>(){
                        {
                            for (Origin origin : OriginLoader.origins) {
                                this.add(origin.getName().toLowerCase());
                            }
                        }
                    };
                }
                yield new ArrayList();
            }
            default -> new ArrayList<String>();
        };
        StringUtil.copyPartialMatches((String)args[args.length - 1], (Iterable)data, result);
        return result;
    }
}

