/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.DamageApplier;
import com.starshootercity.OriginSwapper;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.VisibleAbility;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;

public class WaterVulnerability
implements VisibleAbility,
Listener {
    private final Map<Player, Integer> lastWaterDamagedMap = new HashMap<Player, Integer>();

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:water_vulnerability");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("You receive damage over time while in contact with water.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Hydrophobia", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (Bukkit.getCurrentTick() - this.lastWaterDamagedMap.getOrDefault(player, Bukkit.getCurrentTick() - 20) < 20) continue;
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                if (player.isInWaterOrRainOrBubbleColumn() || ((CraftPlayer)player).getHandle().ai) {
                    DamageApplier.damage((Entity)player, DamageApplier.DamageSource.FREEZING, 1.0f);
                    this.lastWaterDamagedMap.put(player, Bukkit.getCurrentTick());
                }
            });
        }
    }
}

