/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.starshootercity.DamageApplier;
import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.VisibleAbility;
import java.util.List;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class WaterBreathing
implements Listener,
VisibleAbility {
    NamespacedKey airKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "fullair");
    NamespacedKey dehydrationKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "dehydrating");

    @EventHandler
    public void onEntityAirChange(EntityAirChangeEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                if (Boolean.TRUE.equals(player.getPersistentDataContainer().get(this.airKey, PersistentDataType.BOOLEAN))) {
                    return;
                }
                if (Boolean.TRUE.equals(player.getPersistentDataContainer().get(this.dehydrationKey, PersistentDataType.BOOLEAN))) {
                    return;
                }
                if (player.getRemainingAir() - event.getAmount() > 0 ? !player.isUnderWater() && !this.hasWaterBreathing(player) : player.isUnderWater() || this.hasWaterBreathing(player)) {
                    return;
                }
                event.setCancelled(true);
            });
        }
    }

    public boolean hasWaterBreathing(Player player) {
        return player.hasPotionEffect(PotionEffectType.CONDUIT_POWER) || player.hasPotionEffect(PotionEffectType.WATER_BREATHING);
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent ignored) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            AbilityRegister.runForAbility((Entity)player, this.getKey(), () -> {
                if (player.isUnderWater() || this.hasWaterBreathing(player) || player.isInRain()) {
                    if (Boolean.TRUE.equals(player.getPersistentDataContainer().get(this.airKey, PersistentDataType.BOOLEAN))) {
                        player.setRemainingAir(-50);
                        return;
                    }
                    player.setRemainingAir(Math.min(Math.max(player.getRemainingAir() + 4, 4), player.getMaximumAir()));
                    if (player.getRemainingAir() == player.getMaximumAir()) {
                        player.setRemainingAir(-50);
                        player.getPersistentDataContainer().set(this.airKey, PersistentDataType.BOOLEAN, (Object)true);
                    }
                } else {
                    if (Boolean.TRUE.equals(player.getPersistentDataContainer().get(this.airKey, PersistentDataType.BOOLEAN))) {
                        player.setRemainingAir(player.getMaximumAir());
                        player.getPersistentDataContainer().set(this.airKey, PersistentDataType.BOOLEAN, (Object)false);
                    }
                    player.setRemainingAir(player.getRemainingAir() - 1);
                    if (player.getRemainingAir() < -25) {
                        player.getPersistentDataContainer().set(this.dehydrationKey, PersistentDataType.BOOLEAN, (Object)true);
                        player.setRemainingAir(-5);
                        player.getPersistentDataContainer().set(this.dehydrationKey, PersistentDataType.BOOLEAN, (Object)false);
                        DamageApplier.damage((Entity)player, DamageApplier.DamageSource.DRY_OUT, 2.0f);
                    }
                }
            }, () -> {
                if (player.getPersistentDataContainer().has(this.airKey)) {
                    player.setRemainingAir(player.getMaximumAir());
                    player.getPersistentDataContainer().remove(this.airKey);
                }
            });
        }
    }

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:water_breathing");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("You can breathe underwater, but not on land.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Gills", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }
}

