/*
 * Decompiled with CFR 0.152.
 */
package com.starshootercity.abilities;

import com.starshootercity.OriginSwapper;
import com.starshootercity.OriginsReborn;
import com.starshootercity.abilities.AbilityRegister;
import com.starshootercity.abilities.VisibleAbility;
import com.starshootercity.events.PlayerLeftClickEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ThrowEnderPearl
implements VisibleAbility,
Listener {
    private final NamespacedKey falseEnderPearlKey = new NamespacedKey((Plugin)OriginsReborn.getInstance(), "false-ender-pearl");
    private final Map<Player, Integer> lastPearlThrowTickMap = new HashMap<Player, Integer>();

    @Override
    @NotNull
    public Key getKey() {
        return Key.key((String)"origins:throw_ender_pearl");
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getDescription() {
        return OriginSwapper.LineData.makeLineFor("Whenever you want, you may throw an ender pearl which deals no damage, allowing you to teleport.", OriginSwapper.LineData.LineComponent.LineType.DESCRIPTION);
    }

    @Override
    @NotNull
    public List<OriginSwapper.LineData.LineComponent> getTitle() {
        return OriginSwapper.LineData.makeLineFor("Teleportation", OriginSwapper.LineData.LineComponent.LineType.TITLE);
    }

    @EventHandler
    public void onLeftClick(PlayerLeftClickEvent event) {
        if (event.hasBlock()) {
            return;
        }
        AbilityRegister.runForAbility((Entity)event.getPlayer(), this.getKey(), () -> {
            if (Bukkit.getCurrentTick() - this.lastPearlThrowTickMap.getOrDefault(event.getPlayer(), Bukkit.getCurrentTick() - 600) >= 600) {
                this.lastPearlThrowTickMap.put(event.getPlayer(), Bukkit.getCurrentTick());
                if (event.getPlayer().getInventory().getItemInMainHand().getType() != Material.AIR) {
                    return;
                }
                Projectile projectile = event.getPlayer().launchProjectile(EnderPearl.class);
                projectile.getPersistentDataContainer().set(this.falseEnderPearlKey, PersistentDataType.STRING, (Object)event.getPlayer().getName());
            }
        });
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (event.getEntity().getPersistentDataContainer().has(this.falseEnderPearlKey)) {
            event.setCancelled(true);
            String name = (String)event.getEntity().getPersistentDataContainer().get(this.falseEnderPearlKey, PersistentDataType.STRING);
            if (name == null) {
                return;
            }
            Player player = Bukkit.getPlayer((String)name);
            if (player == null) {
                return;
            }
            Location loc = event.getEntity().getLocation();
            loc.setPitch(player.getPitch());
            loc.setYaw(player.getYaw());
            player.teleport(loc);
            event.getEntity().remove();
        }
    }
}

